/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network.payload.protocol;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.paper.PaperReflections;
import net.momirealms.craftengine.bukkit.util.RegistryUtils;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.network.ModPacket;
import net.momirealms.craftengine.core.plugin.network.NetWorkUser;
import net.momirealms.craftengine.core.plugin.network.codec.NetworkCodec;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.core.util.IntIdentityList;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.TranslationArgument;
import org.bukkit.entity.Player;

public record ClientCustomBlockPacket(int size) implements ModPacket
{
    public static final ResourceKey<NetworkCodec<FriendlyByteBuf, ? extends ModPacket>> TYPE = ResourceKey.create(BuiltInRegistries.MOD_PACKET.key().location(), Key.of("craftengine", "client_custom_block"));
    public static final NetworkCodec<FriendlyByteBuf, ClientCustomBlockPacket> CODEC = ModPacket.codec(ClientCustomBlockPacket::encode, ClientCustomBlockPacket::new);

    private ClientCustomBlockPacket(FriendlyByteBuf buf) {
        this(buf.readInt());
    }

    private void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
    }

    @Override
    public ResourceKey<NetworkCodec<FriendlyByteBuf, ? extends ModPacket>> type() {
        return TYPE;
    }

    @Override
    public void handle(NetWorkUser user) {
        if (user.clientModEnabled()) {
            return;
        }
        int serverBlockRegistrySize = RegistryUtils.currentBlockRegistrySize();
        if (this.size != serverBlockRegistrySize) {
            user.kick((Component)Component.translatable((String)"disconnect.craftengine.block_registry_mismatch", (ComponentLike[])new ComponentLike[]{TranslationArgument.numeric((Number)this.size), TranslationArgument.numeric((Number)serverBlockRegistrySize)}));
            return;
        }
        user.setClientModState(true);
        user.setClientBlockList(new IntIdentityList(this.size));
        if (!VersionHelper.isOrAbove1_20_2()) {
            try {
                Object chunkLoader = PaperReflections.field$ServerPlayer$chunkLoader.get(user.serverPlayer());
                LongOpenHashSet sentChunks = (LongOpenHashSet)PaperReflections.field$RegionizedPlayerChunkLoader$PlayerChunkLoaderData$sentChunks.get(chunkLoader);
                Object serverLevel = FastNMS.INSTANCE.field$CraftWorld$ServerLevel(((Player)user.platformPlayer()).getWorld());
                Object lightEngine = CoreReflections.method$BlockAndTintGetter$getLightEngine.invoke(serverLevel, new Object[0]);
                Object chunkSource = FastNMS.INSTANCE.method$ServerLevel$getChunkSource(serverLevel);
                LongIterator longIterator = sentChunks.iterator();
                while (longIterator.hasNext()) {
                    long chunkPos = (Long)longIterator.next();
                    int chunkX = (int)chunkPos;
                    int chunkZ = (int)(chunkPos >> 32);
                    Object levelChunk = FastNMS.INSTANCE.method$ServerChunkCache$getChunk(chunkSource, chunkX, chunkZ, false);
                    Object packet = NetworkReflections.constructor$ClientboundLevelChunkWithLightPacket.newInstance(levelChunk, lightEngine, null, null);
                    user.sendPacket(packet, true);
                }
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to refresh chunk for player " + user.name(), e);
            }
        }
    }
}

