/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.core.util.Direction;
import org.bukkit.block.BlockFace;

public final class DirectionUtils {
    private DirectionUtils() {
    }

    public static Direction toDirection(BlockFace face) {
        return switch (face) {
            case BlockFace.UP -> Direction.UP;
            case BlockFace.DOWN -> Direction.DOWN;
            case BlockFace.NORTH -> Direction.NORTH;
            case BlockFace.SOUTH -> Direction.SOUTH;
            case BlockFace.WEST -> Direction.WEST;
            case BlockFace.EAST -> Direction.EAST;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(face));
        };
    }

    public static BlockFace toBlockFace(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> BlockFace.UP;
            case Direction.DOWN -> BlockFace.DOWN;
            case Direction.NORTH -> BlockFace.NORTH;
            case Direction.SOUTH -> BlockFace.SOUTH;
            case Direction.WEST -> BlockFace.WEST;
            case Direction.EAST -> BlockFace.EAST;
        };
    }

    public static Object toNMSDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> CoreReflections.instance$Direction$UP;
            case Direction.DOWN -> CoreReflections.instance$Direction$DOWN;
            case Direction.NORTH -> CoreReflections.instance$Direction$NORTH;
            case Direction.SOUTH -> CoreReflections.instance$Direction$SOUTH;
            case Direction.WEST -> CoreReflections.instance$Direction$WEST;
            case Direction.EAST -> CoreReflections.instance$Direction$EAST;
        };
    }

    public static Direction fromNMSDirection(Object direction) {
        Enum directionEnum = (Enum)direction;
        int index = directionEnum.ordinal();
        return Direction.values()[index];
    }

    public static boolean isYAxis(Object nmsDirection) {
        return nmsDirection == CoreReflections.instance$Direction$UP || nmsDirection == CoreReflections.instance$Direction$DOWN;
    }
}

