/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import io.papermc.paper.entity.Shearable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.behavior.BlockItemBehavior;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.core.block.BlockKeys;
import net.momirealms.craftengine.core.entity.EntityTypeKeys;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.recipe.RecipeType;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.SingleItemInput;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.QuadFunction;
import net.momirealms.craftengine.core.util.TriFunction;
import net.momirealms.craftengine.core.world.BlockHitResult;
import net.momirealms.craftengine.core.world.BlockPos;
import org.bukkit.GameMode;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Bell;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class InteractUtils {
    private static final Map<Key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean>> INTERACTIONS = new HashMap<Key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean>>();
    private static final Map<Key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean>> WILL_CONSUME = new HashMap<Key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean>>();
    private static final Map<Key, TriFunction<Player, Entity, @Nullable Item<ItemStack>, Boolean>> ENTITY_INTERACTIONS = new HashMap<Key, TriFunction<Player, Entity, Item<ItemStack>, Boolean>>();
    private static final Key NOTE_BLOCK_TOP_INSTRUMENTS = Key.of("minecraft:noteblock_top_instruments");

    private InteractUtils() {
    }

    private static void registerInteraction(Key key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean> function) {
        QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean> previous = INTERACTIONS.put(key, function);
        if (previous != null) {
            CraftEngine.instance().logger().warn("Duplicated interaction check: " + String.valueOf(key));
        }
    }

    private static void registerWillConsume(Key key, QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean> function) {
        QuadFunction<Player, Item<ItemStack>, BlockData, BlockHitResult, Boolean> previous = WILL_CONSUME.put(key, function);
        if (previous != null) {
            CraftEngine.instance().logger().warn("Duplicated interaction check: " + String.valueOf(key));
        }
    }

    private static void registerEntityInteraction(Key key, TriFunction<Player, Entity, @Nullable Item<ItemStack>, Boolean> function) {
        TriFunction<Player, Entity, Item<ItemStack>, Boolean> previous = ENTITY_INTERACTIONS.put(key, function);
        if (previous != null) {
            CraftEngine.instance().logger().warn("Duplicated entity interaction check: " + String.valueOf(key));
        }
    }

    public static boolean isInteractable(Player player, BlockData state, BlockHitResult hit, @Nullable Item<ItemStack> item) {
        Key blockType = BlockStateUtils.getBlockOwnerIdFromData(state);
        if (INTERACTIONS.containsKey(blockType)) {
            return INTERACTIONS.get(blockType).apply(player, item, state, hit);
        }
        return false;
    }

    public static boolean isEntityInteractable(Player player, Entity entity, @Nullable Item<ItemStack> item) {
        TriFunction<Player, Entity, Item<ItemStack>, Boolean> func = ENTITY_INTERACTIONS.get(EntityUtils.getEntityType(entity));
        return func != null && func.apply(player, entity, item) != false;
    }

    public static boolean willConsume(Player player, BlockData state, BlockHitResult hit, @Nullable Item<ItemStack> item) {
        if (item == null) {
            return false;
        }
        Key blockType = BlockStateUtils.getBlockOwnerIdFromData(state);
        if (WILL_CONSUME.containsKey(blockType)) {
            return WILL_CONSUME.get(blockType).apply(player, item, state, hit);
        }
        return false;
    }

    private static boolean canEat(Player player, boolean ignoreHunger) {
        return ignoreHunger || player.isInvulnerable() || player.getFoodLevel() < 20;
    }

    private static boolean canFeed(Entity entity, Item<ItemStack> item) {
        return entity instanceof Animals && item.hasItemTag(Key.of(EntityUtils.getEntityType(entity).value() + "_food"));
    }

    private static boolean hasSaddle(Player player, Entity entity) {
        Steerable steerable;
        return entity instanceof Steerable && (steerable = (Steerable)entity).hasSaddle() && !player.isSneaking();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shearable(Entity entity, Item<ItemStack> item) {
        if (!(entity instanceof Shearable)) return false;
        Shearable shearable = (Shearable)entity;
        if (!item.vanillaId().equals(ItemKeys.SHEARS)) return false;
        if (!shearable.readyToBeSheared()) return false;
        return true;
    }

    private static boolean isPetOwner(Player player, Entity entity) {
        Tameable tameable;
        return entity instanceof Tameable && (tameable = (Tameable)entity).isTamed() && player.getUniqueId().equals(tameable.getOwnerUniqueId());
    }

    static {
        InteractUtils.registerInteraction(BlockKeys.NOTE_BLOCK, (player, item, blockState, result) -> result.getDirection() != Direction.UP || !item.hasItemTag(NOTE_BLOCK_TOP_INSTRUMENTS));
        InteractUtils.registerInteraction(BlockKeys.CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.WHITE_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.ORANGE_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.MAGENTA_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.LIGHT_BLUE_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.YELLOW_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.LIME_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.PINK_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.GRAY_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.LIGHT_GRAY_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.CYAN_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.PURPLE_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.BLUE_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.BROWN_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.GREEN_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.RED_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.BLACK_CANDLE_CAKE, (player, item, blockState, result) -> !InteractUtils.canEat(player, false));
        InteractUtils.registerInteraction(BlockKeys.COMMAND_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.CHAIN_COMMAND_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.REPEATING_COMMAND_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.JIGSAW, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.STRUCTURE_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.TEST_INSTANCE_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.TEST_BLOCK, (player, item, blockState, result) -> player.isOp() && player.getGameMode() == GameMode.CREATIVE);
        InteractUtils.registerInteraction(BlockKeys.LIGHT, (player, item, blockState, result) -> item.vanillaId().equals(ItemKeys.LIGHT));
        InteractUtils.registerInteraction(BlockKeys.LODESTONE, (player, item, blockState, result) -> item.vanillaId().equals(ItemKeys.COMPASS));
        InteractUtils.registerInteraction(BlockKeys.BEE_NEST, (player, item, blockState, result) -> {
            Key id = item.vanillaId();
            return ItemKeys.SHEARS.equals(id) || ItemKeys.GLASS_BOTTLE.equals(id);
        });
        InteractUtils.registerInteraction(BlockKeys.BEEHIVE, (player, item, blockState, result) -> {
            Key id = item.vanillaId();
            return ItemKeys.SHEARS.equals(id) || ItemKeys.GLASS_BOTTLE.equals(id);
        });
        InteractUtils.registerInteraction(BlockKeys.POWDER_SNOW, (player, item, blockState, result) -> item.vanillaId().equals(ItemKeys.BUCKET));
        InteractUtils.registerInteraction(BlockKeys.REDSTONE_ORE, (player, item, blockState, result) -> {
            Optional<List<ItemBehavior>> behaviors = item.getItemBehavior();
            if (behaviors.isPresent()) {
                for (ItemBehavior behavior : behaviors.get()) {
                    if (!(behavior instanceof BlockItemBehavior)) continue;
                    return false;
                }
            }
            return true;
        });
        InteractUtils.registerInteraction(BlockKeys.DEEPSLATE_REDSTONE_ORE, (player, item, blockState, result) -> {
            Optional<List<ItemBehavior>> behaviors = item.getItemBehavior();
            if (behaviors.isPresent()) {
                for (ItemBehavior behavior : behaviors.get()) {
                    if (!(behavior instanceof BlockItemBehavior)) continue;
                    return false;
                }
            }
            return true;
        });
        InteractUtils.registerInteraction(BlockKeys.BELL, (player, item, blockState, result) -> {
            Direction direction = result.getDirection();
            BlockPos pos = result.getBlockPos();
            if (blockState instanceof Bell) {
                Bell bell = (Bell)blockState;
                double y = result.getLocation().y() - (double)pos.y();
                if (direction.axis() != Direction.Axis.Y && y <= (double)0.8124f) {
                    Direction facing = DirectionUtils.toDirection(bell.getFacing());
                    Bell.Attachment attachment = bell.getAttachment();
                    switch (attachment) {
                        case FLOOR: {
                            return facing.axis() == direction.axis();
                        }
                        case DOUBLE_WALL: 
                        case SINGLE_WALL: {
                            return facing.axis() != direction.axis();
                        }
                        case CEILING: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        });
        InteractUtils.registerInteraction(BlockKeys.SOUL_CAMPFIRE, (player, item, blockState, result) -> {
            if (!Config.enableRecipeSystem()) {
                return false;
            }
            return BukkitRecipeManager.instance().recipeByInput(RecipeType.CAMPFIRE_COOKING, new SingleItemInput(UniqueIdItem.of(item))) != null;
        });
        InteractUtils.registerInteraction(BlockKeys.CAMPFIRE, (player, item, blockState, result) -> {
            if (!Config.enableRecipeSystem()) {
                return false;
            }
            return BukkitRecipeManager.instance().recipeByInput(RecipeType.CAMPFIRE_COOKING, new SingleItemInput(UniqueIdItem.of(item))) != null;
        });
        InteractUtils.registerInteraction(BlockKeys.CHISELED_BOOKSHELF, (player, item, blockState, result) -> {
            if (!(blockState instanceof ChiseledBookshelf)) {
                return false;
            }
            ChiseledBookshelf chiseledBookshelf = (ChiseledBookshelf)blockState;
            return DirectionUtils.toDirection(chiseledBookshelf.getFacing()) == result.getDirection();
        });
        InteractUtils.registerInteraction(BlockKeys.COMPOSTER, (player, item, blockState, result) -> {
            Levelled levelled;
            if (((ItemStack)item.getItem()).getType().isCompostable()) {
                return true;
            }
            return blockState instanceof Levelled && (levelled = (Levelled)blockState).getLevel() == levelled.getMaximumLevel();
        });
        InteractUtils.registerInteraction(BlockKeys.RESPAWN_ANCHOR, (player, item, blockState, result) -> {
            RespawnAnchor respawnAnchor;
            if (item.vanillaId().equals(ItemKeys.GLOWSTONE)) {
                return true;
            }
            return blockState instanceof RespawnAnchor && (respawnAnchor = (RespawnAnchor)blockState).getCharges() != 0;
        });
        InteractUtils.registerInteraction(BlockKeys.DECORATED_POT, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.FLOWER_POT, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.HOPPER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DISPENSER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DROPPER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRAFTER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.REPEATER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.COMPARATOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DAYLIGHT_DETECTOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LECTERN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHEST, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ENDER_CHEST, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.TRAPPED_CHEST, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BEACON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ENCHANTING_TABLE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BREWING_STAND, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.GRINDSTONE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ANVIL, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHIPPED_ANVIL, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DAMAGED_ANVIL, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.FURNACE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRAFTING_TABLE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CARTOGRAPHY_TABLE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.STONECUTTER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SMITHING_TABLE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LOOM, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BARREL, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SMOKER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BLAST_FURNACE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LEVER, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.STONE_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.POLISHED_BLACKSTONE_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_BUTTON, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.EXPOSED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OXIDIZED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WEATHERED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_EXPOSED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_OXIDIZED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_WEATHERED_COPPER_DOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.EXPOSED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OXIDIZED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WEATHERED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_EXPOSED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_OXIDIZED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WAXED_WEATHERED_COPPER_TRAPDOOR, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_FENCE_GATE, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_WALL_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.OAK_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SPRUCE_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BIRCH_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ACACIA_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CHERRY_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.JUNGLE_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DARK_OAK_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PALE_OAK_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MANGROVE_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CRIMSON_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WARPED_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BAMBOO_WALL_HANGING_SIGN, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WHITE_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ORANGE_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MAGENTA_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIGHT_BLUE_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.YELLOW_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIME_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PINK_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.GRAY_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIGHT_GRAY_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CYAN_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PURPLE_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BLUE_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BROWN_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.GREEN_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.RED_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BLACK_SHULKER_BOX, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.WHITE_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.ORANGE_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.MAGENTA_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIGHT_BLUE_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.YELLOW_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIME_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PINK_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.GRAY_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.LIGHT_GRAY_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.CYAN_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.PURPLE_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BLUE_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BROWN_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.GREEN_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.RED_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.BLACK_BED, (player, item, blockState, result) -> true);
        InteractUtils.registerInteraction(BlockKeys.DRAGON_EGG, (player, item, blockState, result) -> true);
        InteractUtils.registerWillConsume(BlockKeys.CACTUS, (player, item, blockState, result) -> result.getDirection() == Direction.UP && item.id().equals(ItemKeys.CACTUS));
        InteractUtils.registerWillConsume(BlockKeys.CAULDRON, (player, item, blockState, result) -> {
            Key id = item.vanillaId();
            return ItemKeys.WATER_BUCKET.equals(id) || ItemKeys.LAVA_BUCKET.equals(id);
        });
        InteractUtils.registerWillConsume(BlockKeys.LAVA_CAULDRON, (player, item, blockState, result) -> {
            Key id = item.vanillaId();
            return ItemKeys.BUCKET.equals(id) || ItemKeys.LAVA_BUCKET.equals(id) || ItemKeys.WATER_BUCKET.equals(id);
        });
        InteractUtils.registerWillConsume(BlockKeys.WATER_CAULDRON, (player, item, blockState, result) -> {
            Levelled levelled;
            if (blockState instanceof Levelled && (levelled = (Levelled)blockState).getLevel() == levelled.getMaximumLevel()) {
                return item.vanillaId().equals(ItemKeys.BUCKET);
            }
            Key id = item.vanillaId();
            return ItemKeys.GLASS_BOTTLE.equals(id) || ItemKeys.WATER_BUCKET.equals(id) || ItemKeys.LAVA_BUCKET.equals(id);
        });
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BEE, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.FOX, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.FROG, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PANDA, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.HOGLIN, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.OCELOT, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.RABBIT, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.TURTLE, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CHICKEN, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SNIFFER, (player, entity, item) -> InteractUtils.canFeed(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.AXOLOTL, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.COD, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SALMON, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.TROPICAL_FISH, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PUFFERFISH, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.TADPOLE, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.WATER_BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SNOW_GOLEM, (player, entity, item) -> InteractUtils.shearable(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SHEEP, (player, entity, item) -> InteractUtils.canFeed(entity, item) || InteractUtils.shearable(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BOGGED, (player, entity, item) -> InteractUtils.canFeed(entity, item) || InteractUtils.shearable(entity, item));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.MOOSHROOM, (player, entity, item) -> InteractUtils.canFeed(entity, item) || InteractUtils.shearable(entity, item) || item != null && (item.vanillaId().equals(ItemKeys.BUCKET) || item.vanillaId().equals(ItemKeys.BOWL)));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.COW, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.GOAT, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.BUCKET));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CREEPER, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.FLINT_AND_STEEL));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PIGLIN, (player, entity, item) -> item != null && item.vanillaId().equals(ItemKeys.GOLD_INGOT));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ARMADILLO, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.BRUSH));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ZOMBIE_HORSE, (player, entity, item) -> {
            Tameable tameable;
            return entity instanceof Tameable && (tameable = (Tameable)entity).isTamed();
        });
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SKELETON_HORSE, (player, entity, item) -> {
            Tameable tameable;
            return entity instanceof Tameable && (tameable = (Tameable)entity).isTamed();
        });
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PIG, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.SADDLE) && !InteractUtils.hasSaddle(player, entity) || InteractUtils.hasSaddle(player, entity) && !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.STRIDER, (player, entity, item) -> InteractUtils.canFeed(entity, item) || item != null && item.vanillaId().equals(ItemKeys.SADDLE) && !InteractUtils.hasSaddle(player, entity) || InteractUtils.hasSaddle(player, entity) && !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.WOLF, (player, entity, item) -> InteractUtils.canFeed(entity, item) || InteractUtils.isPetOwner(player, entity));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CAT, (player, entity, item) -> InteractUtils.canFeed(entity, item) || InteractUtils.isPetOwner(player, entity));
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.OAK_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SPRUCE_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BIRCH_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.JUNGLE_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ACACIA_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.DARK_OAK_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.MANGROVE_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CHERRY_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PALE_OAK_BOAT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BAMBOO_RAFT, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.MINECART, (player, entity, item) -> !player.isSneaking());
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PARROT, (player, entity, item) -> {
            if (item != null && item.hasItemTag(Key.of("parrot_poisonous_food"))) {
                return true;
            }
            return InteractUtils.canFeed(entity, item) || InteractUtils.isPetOwner(player, entity);
        });
        InteractUtils.registerEntityInteraction(EntityTypeKeys.HAPPY_GHAST, (player, entity, item) -> {
            if (item != null && item.vanillaId().equals(ItemKeys.HARNESS)) {
                return true;
            }
            if (entity instanceof HappyGhast) {
                HappyGhast happyGhast = (HappyGhast)entity;
                if (!player.isSneaking()) {
                    ItemStack bodyItem = happyGhast.getEquipment().getItem(EquipmentSlot.BODY);
                    return BukkitItemManager.instance().wrap(bodyItem).hasItemTag(Key.of("harnesses"));
                }
            }
            return InteractUtils.canFeed(entity, item);
        });
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ALLAY, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.HORSE, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.DONKEY, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.MULE, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.VILLAGER, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.WANDERING_TRADER, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.LLAMA, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.TRADER_LLAMA, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CAMEL, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ITEM_FRAME, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.GLOW_ITEM_FRAME, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.INTERACTION, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.OAK_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.SPRUCE_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BIRCH_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.JUNGLE_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.ACACIA_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.DARK_OAK_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.MANGROVE_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CHERRY_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.PALE_OAK_CHEST_BOAT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.BAMBOO_CHEST_RAFT, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.CHEST_MINECART, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.FURNACE_MINECART, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.HOPPER_MINECART, (player, entity, item) -> true);
        InteractUtils.registerEntityInteraction(EntityTypeKeys.COMMAND_BLOCK_MINECART, (player, entity, item) -> true);
    }
}

