/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.nms.StorageContainer;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static Player getPlayerFromInventoryEvent(InventoryEvent event) {
        if (VersionHelper.isOrAbove1_21()) {
            return (Player)event.getView().getPlayer();
        }
        return LegacyInventoryUtils.getPlayerFromInventoryEvent(event);
    }

    public static int getSuitableHotBarSlot(PlayerInventory inventory) {
        int i;
        int j;
        int selectedSlot = inventory.getHeldItemSlot();
        for (j = 0; j < 9; ++j) {
            i = (selectedSlot + j) % 9;
            if (!ItemStackUtils.isEmpty(inventory.getItem(i))) continue;
            return i;
        }
        for (j = 0; j < 9; ++j) {
            i = (selectedSlot + j) % 9;
            ItemStack item = inventory.getItem(i);
            if (!ItemStackUtils.isEmpty(item) && !item.getEnchantments().isEmpty()) continue;
            return i;
        }
        return selectedSlot;
    }

    public static int findMatchingItemSlot(PlayerInventory inventory, ItemStack itemStack) {
        ItemStack[] items = inventory.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            ItemStack stack = items[i];
            if (ItemStackUtils.isEmpty(stack) || !stack.isSimilar(itemStack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCustomContainer(Inventory inventory) {
        if (inventory == null) {
            return false;
        }
        Object container = FastNMS.INSTANCE.method$CraftInventory$getInventory(inventory);
        if (container == null) {
            return false;
        }
        return container instanceof StorageContainer;
    }
}

