/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.ColorUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.particle.BlockStateData;
import net.momirealms.craftengine.core.world.particle.ColorData;
import net.momirealms.craftengine.core.world.particle.DustData;
import net.momirealms.craftengine.core.world.particle.DustTransitionData;
import net.momirealms.craftengine.core.world.particle.ItemStackData;
import net.momirealms.craftengine.core.world.particle.JavaTypeData;
import net.momirealms.craftengine.core.world.particle.ParticleData;
import net.momirealms.craftengine.core.world.particle.TrailData;
import net.momirealms.craftengine.core.world.particle.VibrationData;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public final class ParticleUtils {
    private static final Map<Key, Particle> CACHE = new HashMap<Key, Particle>();
    public static final Particle HAPPY_VILLAGER = ParticleUtils.getParticle("HAPPY_VILLAGER");
    public static final Particle BUBBLE = ParticleUtils.getParticle("BUBBLE");

    private ParticleUtils() {
    }

    public static Particle getParticle(String particle) {
        try {
            return Particle.valueOf((String)particle);
        }
        catch (IllegalArgumentException e) {
            return switch (particle) {
                case "REDSTONE" -> Particle.valueOf((String)"DUST");
                case "VILLAGER_HAPPY", "HAPPY_VILLAGER" -> Particle.valueOf((String)(VersionHelper.isOrAbove1_20_5() ? "HAPPY_VILLAGER" : "VILLAGER_HAPPY"));
                case "BUBBLE", "WATER_BUBBLE" -> Particle.valueOf((String)(VersionHelper.isOrAbove1_20_5() ? "BUBBLE" : "WATER_BUBBLE"));
                default -> Particle.valueOf((String)particle);
            };
        }
    }

    @Nullable
    public static Particle getParticle(Key particle) {
        return CACHE.computeIfAbsent(particle, k -> {
            Object nmsParticle = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.PARTICLE_TYPE, KeyUtils.toResourceLocation(particle));
            if (nmsParticle == null) {
                return null;
            }
            return FastNMS.INSTANCE.method$CraftParticle$toBukkit(nmsParticle);
        });
    }

    public static Object toBukkitParticleData(ParticleData particleData, Context context, World world, double x, double y, double z) {
        ParticleData particleData2 = particleData;
        Objects.requireNonNull(particleData2);
        ParticleData particleData3 = particleData2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockStateData.class, ColorData.class, DustData.class, DustTransitionData.class, ItemStackData.class, JavaTypeData.class, VibrationData.class, TrailData.class}, (Object)particleData3, n)) {
            case 0 -> {
                BlockStateData data = (BlockStateData)particleData3;
                yield BlockStateUtils.fromBlockData(data.blockState().literalObject());
            }
            case 1 -> {
                ColorData data = (ColorData)particleData3;
                yield ColorUtils.toBukkit(data.color());
            }
            case 2 -> {
                DustData data = (DustData)particleData3;
                yield new Particle.DustOptions(ColorUtils.toBukkit(data.color()), data.size());
            }
            case 3 -> {
                DustTransitionData data = (DustTransitionData)particleData3;
                yield new Particle.DustTransition(ColorUtils.toBukkit(data.from()), ColorUtils.toBukkit(data.to()), data.size());
            }
            case 4 -> {
                ItemStackData data = (ItemStackData)particleData3;
                yield data.item().getItem();
            }
            case 5 -> {
                JavaTypeData data = (JavaTypeData)particleData3;
                yield data.data();
            }
            case 6 -> {
                VibrationData data = (VibrationData)particleData3;
                yield new Vibration((Vibration.Destination)new Vibration.Destination.BlockDestination(new Location(world, x + data.destinationX().getDouble(context), y + data.destinationY().getDouble(context), y + data.destinationZ().getDouble(context))), data.arrivalTime().getInt(context));
            }
            case 7 -> {
                TrailData data = (TrailData)particleData3;
                yield new Particle.Trail(new Location(world, x + data.targetX().getDouble(context), y + data.targetZ().getDouble(context), z + data.targetZ().getDouble(context)), ColorUtils.toBukkit(data.color()), data.duration().getInt(context));
            }
            default -> null;
        };
    }
}

