/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.advancement.network;

import java.time.Instant;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class CriterionProgress {
    @Nullable
    private Instant obtainedTimestamp;

    public CriterionProgress() {
    }

    public CriterionProgress(@Nullable Instant obtainedTimestamp) {
        this.obtainedTimestamp = obtainedTimestamp;
    }

    public boolean isDone() {
        return this.obtainedTimestamp != null;
    }

    public void grant() {
        this.obtainedTimestamp = Instant.now();
    }

    public void revoke() {
        this.obtainedTimestamp = null;
    }

    @Nullable
    public Instant obtainedTimestamp() {
        return this.obtainedTimestamp;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNullable(this.obtainedTimestamp, FriendlyByteBuf::writeInstant);
    }

    public static CriterionProgress read(FriendlyByteBuf buf) {
        return new CriterionProgress((Instant)buf.readNullable(FriendlyByteBuf::readInstant));
    }
}

