/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.BlockRegistryMirror;
import net.momirealms.craftengine.core.block.BlockSettings;
import net.momirealms.craftengine.core.block.BlockStateAppearance;
import net.momirealms.craftengine.core.block.BlockStateVariant;
import net.momirealms.craftengine.core.block.BlockStateVariantProvider;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.EmptyBlockBehavior;
import net.momirealms.craftengine.core.block.behavior.EntityBlockBehavior;
import net.momirealms.craftengine.core.block.parser.BlockNbtParser;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.loot.LootTable;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomBlock
implements CustomBlock {
    protected final Holder<CustomBlock> holder;
    protected final Key id;
    protected final BlockStateVariantProvider variantProvider;
    protected final Map<String, Property<?>> properties;
    protected final BlockBehavior behavior;
    protected final BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> placementFunction;
    protected final ImmutableBlockState defaultState;
    protected final Map<EventTrigger, List<Function<PlayerOptionalContext>>> events;
    @Nullable
    protected final LootTable<?> lootTable;

    protected AbstractCustomBlock(@NotNull Key id, @NotNull Holder.Reference<CustomBlock> holder, @NotNull Map<String, Property<?>> properties, @NotNull Map<String, BlockStateAppearance> appearances, @NotNull Map<String, BlockStateVariant> variantMapper, @NotNull BlockSettings settings, @NotNull Map<EventTrigger, List<Function<PlayerOptionalContext>>> events, @Nullable List<Map<String, Object>> behaviorConfig, @Nullable LootTable<?> lootTable) {
        holder.bindValue(this);
        this.holder = holder;
        this.id = id;
        this.lootTable = lootTable;
        this.properties = ImmutableMap.copyOf(properties);
        this.events = events;
        this.variantProvider = new BlockStateVariantProvider(holder, ImmutableBlockState::new, properties);
        this.defaultState = this.variantProvider.getDefaultState();
        this.behavior = this.setupBehavior(behaviorConfig);
        ArrayList<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>> placements = new ArrayList<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>>(4);
        for (Map.Entry<String, Property<?>> propertyEntry : this.properties.entrySet()) {
            placements.add(Property.createStateForPlacement(propertyEntry.getKey(), propertyEntry.getValue()));
        }
        this.placementFunction = AbstractCustomBlock.composite(placements);
        EntityBlockBehavior entityBlockBehavior = this.behavior.getEntityBehavior();
        boolean isEntityBlock = entityBlockBehavior != null;
        for (Map.Entry<String, BlockStateVariant> entry : variantMapper.entrySet()) {
            String nbtString = entry.getKey();
            CompoundTag tag = BlockNbtParser.deserialize(this, nbtString);
            if (tag == null) {
                throw new LocalizedResourceConfigException("warning.config.block.state.property.invalid_format", nbtString);
            }
            List<ImmutableBlockState> possibleStates = this.getPossibleStates(tag);
            if (possibleStates.size() != 1) {
                throw new LocalizedResourceConfigException("warning.config.block.state.property.invalid_format", nbtString);
            }
            BlockStateVariant blockStateVariant = entry.getValue();
            BlockStateAppearance blockStateAppearance = appearances.getOrDefault(blockStateVariant.appearance(), BlockStateAppearance.INVALID);
            int stateId = blockStateAppearance.isInvalid() ? appearances.values().iterator().next().stateRegistryId() : blockStateAppearance.stateRegistryId();
            ImmutableBlockState state = possibleStates.getFirst();
            state.setSettings(blockStateVariant.settings());
            state.setVanillaBlockState(BlockRegistryMirror.stateByRegistryId(stateId));
            state.setCustomBlockState(BlockRegistryMirror.stateByRegistryId(blockStateVariant.internalRegistryId()));
            blockStateAppearance.blockEntityRenderer().ifPresent(state::setConstantRenderers);
        }
        for (ImmutableBlockState state : this.variantProvider().states()) {
            state.setBehavior(this.behavior);
            if (state.settings() == null) {
                state.setSettings(settings);
            }
            if (!isEntityBlock) continue;
            state.setBlockEntityType(entityBlockBehavior.blockEntityType());
        }
        this.applyPlatformSettings();
    }

    protected BlockBehavior setupBehavior(List<Map<String, Object>> behaviorConfig) {
        return EmptyBlockBehavior.INSTANCE;
    }

    private static BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> composite(List<BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState>> placements) {
        return switch (placements.size()) {
            case 0 -> (c, i) -> i;
            case 1 -> placements.get(0);
            case 2 -> {
                BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> f1 = placements.get(0);
                BiFunction<BlockPlaceContext, ImmutableBlockState, ImmutableBlockState> f2 = placements.get(1);
                yield (c, i) -> (ImmutableBlockState)f2.apply((BlockPlaceContext)c, (ImmutableBlockState)f1.apply((BlockPlaceContext)c, (ImmutableBlockState)i));
            }
            default -> (c, i) -> {
                for (BiFunction f : placements) {
                    i = (ImmutableBlockState)f.apply(c, i);
                }
                return i;
            };
        };
    }

    protected abstract void applyPlatformSettings();

    @Override
    @Nullable
    public LootTable<?> lootTable() {
        return this.lootTable;
    }

    @Override
    public void execute(PlayerOptionalContext context, EventTrigger trigger) {
        for (Function function : Optional.ofNullable(this.events.get((Object)trigger)).orElse(Collections.emptyList())) {
            function.run(context);
        }
    }

    @Override
    @NotNull
    public BlockStateVariantProvider variantProvider() {
        return this.variantProvider;
    }

    @Override
    @NotNull
    public final Key id() {
        return this.id;
    }

    @Override
    public List<ImmutableBlockState> getPossibleStates(CompoundTag nbt) {
        ArrayList<ImmutableBlockState> tempStates = new ArrayList<ImmutableBlockState>();
        tempStates.add(this.defaultState());
        for (Property<?> property : this.variantProvider.getDefaultState().getProperties()) {
            Tag value = nbt.get(property.name());
            if (value != null) {
                tempStates.replaceAll(immutableBlockState -> ImmutableBlockState.with(immutableBlockState, property, property.unpack(value)));
                continue;
            }
            ArrayList<ImmutableBlockState> newStates = new ArrayList<ImmutableBlockState>();
            for (ImmutableBlockState state : tempStates) {
                for (Object possibleValue : property.possibleValues()) {
                    newStates.add(ImmutableBlockState.with(state, property, possibleValue));
                }
            }
            tempStates = newStates;
        }
        return tempStates;
    }

    @Override
    public ImmutableBlockState getBlockState(CompoundTag nbt) {
        ImmutableBlockState state = this.defaultState();
        for (Map.Entry<String, Tag> entry : nbt.tags.entrySet()) {
            Property<?> property = this.variantProvider.getProperty(entry.getKey());
            if (property == null) continue;
            try {
                state = ImmutableBlockState.with(state, property, property.unpack(entry.getValue()));
            }
            catch (Exception e) {
                CraftEngine.instance().logger().warn("Failed to parse block state: " + entry.getKey(), e);
            }
        }
        return state;
    }

    @Override
    @Nullable
    public Property<?> getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    @NotNull
    public Collection<Property<?>> properties() {
        return this.properties.values();
    }

    @Override
    public final ImmutableBlockState defaultState() {
        return this.defaultState;
    }

    @Override
    public ImmutableBlockState getStateForPlacement(BlockPlaceContext context) {
        ImmutableBlockState state = this.placementFunction.apply(context, this.defaultState());
        return this.behavior.updateStateForPlacement(context, state);
    }

    @Override
    public void setPlacedBy(BlockPlaceContext context, ImmutableBlockState state) {
        this.behavior.setPlacedBy(context, state);
    }
}

