/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.block;

import java.util.Optional;
import java.util.concurrent.Callable;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.EntityBlockBehavior;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.behavior.BlockBoundItemBehavior;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.context.BlockPlaceContext;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BlockBehavior {
    public <T extends BlockBehavior> Optional<T> getAs(Class<T> tClass) {
        if (tClass.isInstance(this)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Nullable
    public EntityBlockBehavior getEntityBehavior() {
        BlockBehavior blockBehavior = this;
        if (blockBehavior instanceof EntityBlockBehavior) {
            EntityBlockBehavior behavior = (EntityBlockBehavior)((Object)blockBehavior);
            return behavior;
        }
        return null;
    }

    public Object rotate(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return superMethod.call();
    }

    public Object mirror(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return superMethod.call();
    }

    public Object updateShape(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return args[0];
    }

    public void neighborChanged(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        superMethod.call();
    }

    public void tick(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        superMethod.call();
    }

    public void randomTick(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        superMethod.call();
    }

    public void onPlace(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        superMethod.call();
    }

    public boolean canSurvive(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return (Boolean)superMethod.call();
    }

    public boolean isPathFindable(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return (Boolean)superMethod.call();
    }

    public void onBrokenAfterFall(Object thisBlock, Object[] args) throws Exception {
    }

    public void onLand(Object thisBlock, Object[] args) throws Exception {
    }

    public boolean isValidBoneMealTarget(Object thisBlock, Object[] args) throws Exception {
        return false;
    }

    public boolean hasAnalogOutputSignal(Object thisBlock, Object[] args) throws Exception {
        return false;
    }

    public int getAnalogOutputSignal(Object thisBlock, Object[] args) throws Exception {
        return 0;
    }

    public Object getContainer(Object thisBlock, Object[] args) throws Exception {
        return null;
    }

    public boolean isBoneMealSuccess(Object thisBlock, Object[] args) throws Exception {
        return false;
    }

    public void performBoneMeal(Object thisBlock, Object[] args) throws Exception {
    }

    public void onExplosionHit(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
    }

    public boolean placeLiquid(Object thisObj, Object[] args, Callable<Object> superMethod) {
        return false;
    }

    public boolean canPlaceLiquid(Object thisObj, Object[] args, Callable<Object> superMethod) {
        return false;
    }

    public Object pickupBlock(Object thisObj, Object[] args, Callable<Object> superMethod) throws Exception {
        return superMethod.call();
    }

    public void entityInside(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
    }

    public void affectNeighborsAfterRemoval(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
    }

    @ApiStatus.Obsolete
    public void onRemove(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
    }

    public int getSignal(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        return 0;
    }

    public int getDirectSignal(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        return 0;
    }

    public boolean isSignalSource(Object thisBlock, Object[] args, Callable<Object> superMethod) {
        return false;
    }

    public Object playerWillDestroy(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
        return superMethod.call();
    }

    public void spawnAfterBreak(Object thisBlock, Object[] args, Callable<Object> superMethod) throws Exception {
    }

    public ImmutableBlockState updateStateForPlacement(BlockPlaceContext context, ImmutableBlockState state) {
        return state;
    }

    public boolean canBeReplaced(BlockPlaceContext context, ImmutableBlockState state) {
        Key clickedBlockId = state.owner().value().id();
        Item<?> item = context.getItem();
        Optional customItem = CraftEngine.instance().itemManager().getCustomItem(item.id());
        if (customItem.isEmpty()) {
            return state.settings().replaceable();
        }
        CustomItem custom = customItem.get();
        for (ItemBehavior behavior : custom.behaviors()) {
            BlockBoundItemBehavior blockItemBehavior;
            Key blockId;
            if (!(behavior instanceof BlockBoundItemBehavior) || !(blockId = (blockItemBehavior = (BlockBoundItemBehavior)behavior).block()).equals(clickedBlockId)) continue;
            return false;
        }
        return state.settings().replaceable();
    }

    public void setPlacedBy(BlockPlaceContext context, ImmutableBlockState state) {
    }

    public InteractionResult useOnBlock(UseOnContext context, ImmutableBlockState state) {
        return InteractionResult.TRY_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(UseOnContext context, ImmutableBlockState state) {
        return InteractionResult.PASS;
    }

    public abstract CustomBlock block();
}

