/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.entity.furniture;

import java.io.IOException;
import java.util.Optional;
import net.momirealms.craftengine.core.entity.furniture.AnchorType;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.util.Color;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NBT;

public class FurnitureExtraData {
    public static final String ITEM = "item";
    public static final String DYED_COLOR = "dyed_color";
    public static final String FIREWORK_EXPLOSION_COLORS = "firework_explosion_colors";
    public static final String ANCHOR_TYPE = "anchor_type";
    private final CompoundTag data;

    public FurnitureExtraData(CompoundTag data) {
        this.data = data;
    }

    public static FurnitureExtraData of(CompoundTag data) {
        return new FurnitureExtraData(data);
    }

    public CompoundTag copyTag() {
        return this.data.copy();
    }

    public CompoundTag unsafeTag() {
        return this.data;
    }

    public Optional<Item<?>> item() {
        byte[] data = this.data.getByteArray(ITEM);
        if (data == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(CraftEngine.instance().itemManager().fromByteArray(data));
        }
        catch (Exception e) {
            Debugger.FURNITURE.warn(() -> "Failed to read furniture item data", e);
            return Optional.empty();
        }
    }

    public Optional<int[]> fireworkExplosionColors() {
        if (this.data.containsKey(FIREWORK_EXPLOSION_COLORS)) {
            return Optional.of(this.data.getIntArray(FIREWORK_EXPLOSION_COLORS));
        }
        return Optional.empty();
    }

    public Optional<Color> dyedColor() {
        if (this.data.containsKey(DYED_COLOR)) {
            return Optional.of(Color.fromDecimal(this.data.getInt(DYED_COLOR)));
        }
        return Optional.empty();
    }

    public Optional<AnchorType> anchorType() {
        if (this.data.containsKey(ANCHOR_TYPE)) {
            return Optional.of(AnchorType.byId(this.data.getInt(ANCHOR_TYPE)));
        }
        return Optional.empty();
    }

    public FurnitureExtraData anchorType(AnchorType type) {
        this.data.putInt(ANCHOR_TYPE, type.getId());
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FurnitureExtraData fromBytes(byte[] data) throws IOException {
        return new FurnitureExtraData(NBT.fromBytes(data));
    }

    public static byte[] toBytes(FurnitureExtraData data) throws IOException {
        return NBT.toBytes(data.data);
    }

    public byte[] toBytes() throws IOException {
        return FurnitureExtraData.toBytes(this);
    }

    public static class Builder {
        private final CompoundTag data = new CompoundTag();

        public Builder item(Item<?> item) {
            this.data.putByteArray(FurnitureExtraData.ITEM, item.toByteArray());
            return this;
        }

        public Builder dyedColor(Color color) {
            if (color == null) {
                return this;
            }
            this.data.putInt(FurnitureExtraData.DYED_COLOR, color.color());
            return this;
        }

        public Builder fireworkExplosionColors(int[] colors) {
            if (colors == null) {
                return this;
            }
            this.data.putIntArray(FurnitureExtraData.FIREWORK_EXPLOSION_COLORS, colors);
            return this;
        }

        public Builder anchorType(AnchorType type) {
            this.data.putInt(FurnitureExtraData.ANCHOR_TYPE, type.getId());
            return this;
        }

        public FurnitureExtraData build() {
            return new FurnitureExtraData(this.data);
        }
    }
}

