/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.font;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.font.BitmapImage;
import net.momirealms.craftengine.core.font.EmojiComponentProcessResult;
import net.momirealms.craftengine.core.font.EmojiTextProcessResult;
import net.momirealms.craftengine.core.font.Font;
import net.momirealms.craftengine.core.font.FontTagFormatter;
import net.momirealms.craftengine.core.font.IllegalCharacterProcessResult;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.FormatUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FontManager
extends Manageable {
    public static final Key DEFAULT_FONT = Key.of("minecraft:default");
    public static final String BYPASS_BOOK = "craftengine.filter.bypass.book";
    public static final String BYPASS_SIGN = "craftengine.filter.bypass.sign";
    public static final String BYPASS_CHAT = "craftengine.filter.bypass.chat";
    public static final String BYPASS_COMMAND = "craftengine.filter.bypass.command";
    public static final String BYPASS_ANVIL = "craftengine.filter.bypass.anvil";

    default public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component text, @Nullable Player player) {
        return this.replaceComponentEmoji(text, player, Config.maxEmojisPerParse());
    }

    default public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component text, @Nullable Player player, int maxTimes) {
        return this.replaceComponentEmoji(text, player, AdventureHelper.plainTextContent(text), maxTimes);
    }

    default public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component text, @Nullable Player player, String raw) {
        return this.replaceComponentEmoji(text, player, raw, Config.maxEmojisPerParse());
    }

    public EmojiComponentProcessResult replaceComponentEmoji(@NotNull Component var1, @Nullable Player var2, @NotNull String var3, int var4);

    default public IllegalCharacterProcessResult processIllegalCharacters(String raw) {
        return this.processIllegalCharacters(raw, '*');
    }

    public IllegalCharacterProcessResult processIllegalCharacters(String var1, char var2);

    public ConfigParser[] parsers();

    default public EmojiTextProcessResult replaceMiniMessageEmoji(@NotNull String miniMessage, @Nullable Player player) {
        return this.replaceMiniMessageEmoji(miniMessage, player, Config.maxEmojisPerParse());
    }

    public EmojiTextProcessResult replaceMiniMessageEmoji(@NotNull String var1, @Nullable Player var2, int var3);

    default public EmojiTextProcessResult replaceJsonEmoji(@NotNull String json, @Nullable Player player) {
        return this.replaceJsonEmoji(json, player, Config.maxEmojisPerParse());
    }

    public EmojiTextProcessResult replaceJsonEmoji(@NotNull String var1, @Nullable Player var2, int var3);

    public boolean isDefaultFontInUse();

    public boolean isIllegalCodepoint(int var1);

    public Collection<Font> fonts();

    public Optional<BitmapImage> bitmapImageByCodepoint(Key var1, int var2);

    default public Optional<BitmapImage> bitmapImageByChars(Key font, char[] chars) {
        return this.bitmapImageByCodepoint(font, CharacterUtils.charsToCodePoint(chars));
    }

    public Optional<BitmapImage> bitmapImageByImageId(Key var1);

    public Optional<Font> fontById(Key var1);

    public int codepointByImageId(Key var1, int var2, int var3);

    default public int codepointByImageId(Key imageId) {
        return this.codepointByImageId(imageId, 0, 0);
    }

    default public char[] charsByImageId(Key imageId) {
        return this.charsByImageId(imageId, 0, 0);
    }

    default public char[] charsByImageId(Key imageId, int x, int y) {
        return Character.toChars(this.codepointByImageId(imageId, x, y));
    }

    public String createOffsets(int var1, FontTagFormatter var2);

    default public String createMiniMessageOffsets(int offset) {
        return this.createOffsets(offset, FormatUtils::miniMessageFont);
    }

    default public String createMineDownOffsets(int offset) {
        return this.createOffsets(offset, FormatUtils::mineDownFont);
    }

    default public String createRawOffsets(int offset) {
        return this.createOffsets(offset, (raw, font) -> raw);
    }

    public Map<String, ComponentProvider> matchTags(String var1);

    public void refreshEmojiSuggestions(UUID var1);
}

