/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.modifier.lore;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.plugin.text.minimessage.FormattedLine;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.TriFunction;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public record LoreModification(Operation operation, boolean split, FormattedLine[] content) {
    public Stream<Component> apply(Stream<Component> lore, ItemBuildContext context) {
        return this.operation.function.apply(lore, context, this);
    }

    public Stream<Component> parseAsStream(ItemBuildContext context) {
        Stream<Component> parsed = Arrays.stream(this.content).map(line -> line.parse(context));
        return this.split ? parsed.map(AdventureHelper::splitLines).flatMap(Collection::stream) : parsed;
    }

    public List<Component> parseAsList(ItemBuildContext context) {
        return this.parseAsStream(context).toList();
    }

    public static enum Operation {
        APPEND((s, c, modification) -> Stream.concat(s, modification.parseAsStream((ItemBuildContext)c))),
        PREPEND((s, c, modification) -> Stream.concat(modification.parseAsStream((ItemBuildContext)c), s));

        private final TriFunction<Stream<Component>, ItemBuildContext, LoreModification, Stream<Component>> function;

        private Operation(TriFunction<Stream<Component>, ItemBuildContext, LoreModification, Stream<Component>> function) {
            this.function = function;
        }
    }
}

