/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.recipe;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.momirealms.craftengine.core.item.recipe.Ingredient;

public class PlacementInfo<T> {
    private final List<Ingredient<T>> ingredients;
    private final IntList slotsToIngredientIndex;

    private PlacementInfo(List<Ingredient<T>> ingredients, IntList placementSlots) {
        this.ingredients = ingredients;
        this.slotsToIngredientIndex = placementSlots;
    }

    public static <T> PlacementInfo<T> create(List<Ingredient<T>> ingredients) {
        int i = ingredients.size();
        IntArrayList intList = new IntArrayList(i);
        for (int j = 0; j < i; ++j) {
            Ingredient<T> ingredient = ingredients.get(j);
            if (ingredient.isEmpty()) {
                return new PlacementInfo<T>(List.of(), IntList.of());
            }
            intList.add(j);
        }
        return new PlacementInfo<T>(ingredients, (IntList)intList);
    }

    public List<Ingredient<T>> ingredients() {
        return this.ingredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotsToIngredientIndex.isEmpty();
    }
}

