/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.item.updater;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.updater.ItemUpdateResult;
import net.momirealms.craftengine.core.item.updater.ItemUpdater;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class ItemUpdateConfig {
    private final List<Version> versions;
    private final int maxVersion;

    public ItemUpdateConfig(List<Version> versions) {
        this.versions = new ArrayList<Version>(versions);
        this.versions.sort(Version::compareTo);
        int maxVersion = 0;
        for (Version version : versions) {
            maxVersion = Math.max(maxVersion, version.version);
        }
        this.maxVersion = maxVersion;
    }

    public int maxVersion() {
        return this.maxVersion;
    }

    public ItemUpdateResult update(Item<?> item, Supplier<ItemBuildContext> context) {
        Tag versionTag = item.getTag("craftengine:version");
        int currentVersion = 0;
        if (versionTag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)versionTag;
            currentVersion = numericTag.getAsInt();
        }
        if (currentVersion >= this.maxVersion) {
            return new ItemUpdateResult(item, false, false);
        }
        ItemBuildContext buildContext = context.get();
        Item<?> orginalItem = item;
        for (Version version : this.versions) {
            if (currentVersion >= version.version) continue;
            item = version.apply(item, buildContext);
        }
        item.setTag(this.maxVersion, "craftengine:version");
        return new ItemUpdateResult(item, orginalItem != item, true);
    }

    public record Version(int version, ItemUpdater<?>[] updaters) implements Comparable<Version>
    {
        public <T> Item<T> apply(Item<T> item, ItemBuildContext context) {
            for (ItemUpdater<?> updater : this.updaters) {
                item = updater.update(item, context);
            }
            return item;
        }

        @Override
        public int compareTo(@NotNull Version o) {
            return Integer.compare(this.version, o.version);
        }
    }
}

