/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.loot.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.loot.LootContext;
import net.momirealms.craftengine.core.loot.function.ApplyBonusCountFunction;
import net.momirealms.craftengine.core.loot.function.DropExpFunction;
import net.momirealms.craftengine.core.loot.function.ExplosionDecayFunction;
import net.momirealms.craftengine.core.loot.function.LootFunction;
import net.momirealms.craftengine.core.loot.function.LootFunctionFactory;
import net.momirealms.craftengine.core.loot.function.SetCountFunction;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class LootFunctions {
    public static final Key APPLY_BONUS = Key.from("craftengine:apply_bonus");
    public static final Key SET_COUNT = Key.from("craftengine:set_count");
    public static final Key EXPLOSION_DECAY = Key.from("craftengine:explosion_decay");
    public static final Key DROP_EXP = Key.from("craftengine:drop_exp");

    public static <T> void register(Key key, LootFunctionFactory<T> factory) {
        ((WritableRegistry)BuiltInRegistries.LOOT_FUNCTION_FACTORY).register(ResourceKey.create(Registries.LOOT_FUNCTION_FACTORY.location(), key), factory);
    }

    public static <T> BiFunction<Item<T>, LootContext, Item<T>> identity() {
        return (item, context) -> item;
    }

    public static <T> BiFunction<Item<T>, LootContext, Item<T>> compose(List<? extends BiFunction<Item<T>, LootContext, Item<T>>> terms) {
        List list = List.copyOf(terms);
        return switch (list.size()) {
            case 0 -> LootFunctions.identity();
            case 1 -> list.get(0);
            case 2 -> {
                BiFunction f1 = list.get(0);
                BiFunction f2 = list.get(1);
                yield (item, context) -> (Item)f2.apply((Item)f1.apply((Item)item, (LootContext)context), (LootContext)context);
            }
            default -> (item, context) -> {
                for (BiFunction function : list) {
                    item = (Item)function.apply(item, context);
                }
                return item;
            };
        };
    }

    public static <T> List<LootFunction<T>> fromMapList(List<Map<String, Object>> mapList) {
        if (mapList == null || mapList.isEmpty()) {
            return List.of();
        }
        ArrayList<LootFunction<T>> functions = new ArrayList<LootFunction<T>>();
        for (Map<String, Object> map : mapList) {
            functions.add(LootFunctions.fromMap(map));
        }
        return functions;
    }

    public static <T> LootFunction<T> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.loot_table.function.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        LootFunctionFactory<?> factory = BuiltInRegistries.LOOT_FUNCTION_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.loot_table.function.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        LootFunctions.register(SET_COUNT, SetCountFunction.FACTORY);
        LootFunctions.register(EXPLOSION_DECAY, ExplosionDecayFunction.FACTORY);
        LootFunctions.register(APPLY_BONUS, ApplyBonusCountFunction.FACTORY);
        LootFunctions.register(DROP_EXP, DropExpFunction.FACTORY);
    }
}

