/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import org.jetbrains.annotations.NotNull;

public class PackCacheData {
    private final Set<Path> externalZips;
    private final Set<Path> externalFolders = Config.foldersToMerge().stream().map(it -> plugin.dataFolderPath().getParent().resolve((String)it)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toSet());

    PackCacheData(@NotNull CraftEngine plugin) {
        this.externalZips = Config.zipsToMerge().stream().map(it -> plugin.dataFolderPath().getParent().resolve((String)it)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().endsWith(".zip")).collect(Collectors.toSet());
    }

    @NotNull
    public Set<Path> externalFolders() {
        return this.externalFolders;
    }

    @NotNull
    public Set<Path> externalZips() {
        return this.externalZips;
    }
}

