/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.conflict.resolution;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.momirealms.craftengine.core.pack.conflict.PathContext;
import net.momirealms.craftengine.core.pack.conflict.resolution.Resolution;
import net.momirealms.craftengine.core.pack.conflict.resolution.ResolutionFactory;
import net.momirealms.craftengine.core.pack.conflict.resolution.Resolutions;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class ResolutionMergeJson
implements Resolution {
    public static final Factory FACTORY = new Factory();
    private final boolean deeply;

    public ResolutionMergeJson(boolean deeply) {
        this.deeply = deeply;
    }

    @Override
    public void run(PathContext existing, PathContext conflict) {
        try {
            JsonObject j1 = GsonHelper.readJsonFile(existing.path()).getAsJsonObject();
            JsonObject j2 = GsonHelper.readJsonFile(conflict.path()).getAsJsonObject();
            JsonObject j3 = this.deeply ? GsonHelper.deepMerge(j1, j2) : GsonHelper.shallowMerge(j1, j2);
            GsonHelper.writeJsonFile((JsonElement)j3, existing.path());
        }
        catch (IOException e) {
            CraftEngine.instance().logger().severe("Failed to merge json when resolving file conflicts", e);
        }
    }

    @Override
    public Key type() {
        return Resolutions.MERGE_JSON;
    }

    public static class Factory
    implements ResolutionFactory {
        @Override
        public Resolution create(Map<String, Object> arguments) {
            boolean deeply = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("deeply", false), "deeply");
            return new ResolutionMergeJson(deeply);
        }
    }
}

