/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.host.impl;

import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import net.momirealms.craftengine.core.pack.host.ResourcePackDownloadData;
import net.momirealms.craftengine.core.pack.host.ResourcePackHost;
import net.momirealms.craftengine.core.pack.host.ResourcePackHostFactory;
import net.momirealms.craftengine.core.pack.host.ResourcePackHosts;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.util.HashUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsBasicCredentials;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsCredentials;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.AwsCredentialsProvider;
import net.momirealms.craftengine.libraries.awssdk.auth.credentials.StaticCredentialsProvider;
import net.momirealms.craftengine.libraries.awssdk.auth.signer.AwsS3V4Signer;
import net.momirealms.craftengine.libraries.awssdk.core.async.AsyncRequestBody;
import net.momirealms.craftengine.libraries.awssdk.core.client.config.SdkAdvancedClientOption;
import net.momirealms.craftengine.libraries.awssdk.http.async.SdkAsyncHttpClient;
import net.momirealms.craftengine.libraries.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import net.momirealms.craftengine.libraries.awssdk.http.nio.netty.ProxyConfiguration;
import net.momirealms.craftengine.libraries.awssdk.regions.Region;
import net.momirealms.craftengine.libraries.awssdk.services.s3.S3AsyncClient;
import net.momirealms.craftengine.libraries.awssdk.services.s3.S3AsyncClientBuilder;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.HeadObjectRequest;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.NoSuchKeyException;
import net.momirealms.craftengine.libraries.awssdk.services.s3.model.PutObjectRequest;
import net.momirealms.craftengine.libraries.awssdk.services.s3.presigner.S3Presigner;
import net.momirealms.craftengine.libraries.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import net.momirealms.craftengine.libraries.caffeine.cache.Cache;
import net.momirealms.craftengine.libraries.caffeine.cache.Caffeine;
import net.momirealms.craftengine.libraries.caffeine.cache.Scheduler;

public class S3Host
implements ResourcePackHost {
    public static final Factory FACTORY = new Factory();
    private final S3AsyncClient s3AsyncClient;
    private final S3Presigner preSigner;
    private final String bucket;
    private final String uploadPath;
    private final String cdnDomain;
    private final String cdnProtocol;
    private final Duration validity;
    private final int maxRequests;
    private final int resetInterval;
    private final boolean enableRateLimit;
    private final Cache<UUID, UserAccessRecord> userAccessCache = Caffeine.newBuilder().maximumSize(256L).scheduler(Scheduler.systemScheduler()).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public S3Host(S3AsyncClient s3AsyncClient, S3Presigner preSigner, String bucket, String uploadPath, String cdnDomain, String cdnProtocol, Duration validity, int maxRequests, int resetInterval) {
        this.s3AsyncClient = s3AsyncClient;
        this.preSigner = preSigner;
        this.bucket = bucket;
        this.uploadPath = uploadPath;
        this.cdnDomain = cdnDomain;
        this.cdnProtocol = cdnProtocol;
        this.validity = validity;
        this.maxRequests = maxRequests;
        this.resetInterval = resetInterval;
        this.enableRateLimit = maxRequests > 0 && resetInterval > 0;
    }

    @Override
    public boolean canUpload() {
        return true;
    }

    @Override
    public Key type() {
        return ResourcePackHosts.S3;
    }

    @Override
    public CompletableFuture<List<ResourcePackDownloadData>> requestResourcePackDownloadLink(UUID player) {
        if (this.checkRateLimit(player)) {
            Debugger.RESOURCE_PACK.debug(() -> "[S3] Rate limit exceeded for player " + String.valueOf(player) + ". Skipping request.");
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.s3AsyncClient.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucket).key(this.uploadPath).build()).handle((headResponse, exception) -> {
            if (exception != null) {
                Throwable cause = exception.getCause();
                if (cause instanceof NoSuchKeyException) {
                    NoSuchKeyException e2 = (NoSuchKeyException)cause;
                    CraftEngine.instance().logger().warn("[S3] Resource pack not found in bucket '" + this.bucket + "'. Path: " + this.uploadPath, (Throwable)e2);
                } else {
                    CraftEngine.instance().logger().warn("[S3] Failed to retrieve resource pack metadata.", (Throwable)exception);
                }
                return Collections.emptyList();
            }
            String sha1 = (String)headResponse.metadata().get("sha1");
            if (sha1 == null) {
                CraftEngine.instance().logger().warn("[S3] Missing SHA-1 checksum in object metadata. Path: " + this.uploadPath);
                throw new CompletionException(new IllegalStateException("Missing SHA-1 metadata for S3 object: " + this.uploadPath));
            }
            GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().signatureDuration(this.validity).getObjectRequest(b2 -> b2.bucket(this.bucket).key(this.uploadPath)).build();
            return Collections.singletonList(ResourcePackDownloadData.of(this.replaceWithCdnUrl(this.preSigner.presignGetObject(presignRequest).url()), UUID.nameUUIDFromBytes(sha1.getBytes(StandardCharsets.UTF_8)), sha1));
        });
    }

    @Override
    public CompletableFuture<Void> upload(Path resourcePackPath) {
        String sha1 = HashUtils.calculateLocalFileSha1(resourcePackPath);
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(this.uploadPath).metadata(Map.of("sha1", sha1)).build();
        long uploadStart = System.currentTimeMillis();
        CraftEngine.instance().logger().info("[S3] Initiating resource pack upload to '" + this.uploadPath + "'");
        return this.s3AsyncClient.putObject(putObjectRequest, AsyncRequestBody.fromFile((Path)resourcePackPath)).handle((response, exception) -> {
            if (exception != null) {
                Throwable cause = exception instanceof CompletionException ? exception.getCause() : exception;
                CraftEngine.instance().logger().warn("[S3] Upload failed for path '" + this.uploadPath + "'. Error: " + cause.getClass().getSimpleName() + " - " + cause.getMessage(), (Throwable)exception);
            } else {
                CraftEngine.instance().logger().info("[S3] Successfully uploaded resource pack to '" + this.uploadPath + "' in " + (System.currentTimeMillis() - uploadStart) + " ms");
            }
            return null;
        });
    }

    private String replaceWithCdnUrl(URL originalUrl) {
        if (this.cdnDomain == null || this.cdnDomain.isEmpty()) {
            return originalUrl.toString();
        }
        return this.cdnProtocol + "://" + this.cdnDomain + originalUrl.getPath() + (String)(originalUrl.getQuery() != null ? "?" + originalUrl.getQuery() : "");
    }

    private boolean checkRateLimit(UUID user) {
        if (!this.enableRateLimit) {
            return false;
        }
        UserAccessRecord record = (UserAccessRecord)this.userAccessCache.getIfPresent((Object)user);
        long now = System.currentTimeMillis();
        if (record == null) {
            record = new UserAccessRecord(now, 1);
            this.userAccessCache.put((Object)user, (Object)record);
            return false;
        }
        if (now - record.lastAccessTime > (long)this.resetInterval) {
            record.lastAccessTime = now;
            record.accessCount = 1;
            return false;
        }
        return ++record.accessCount > this.maxRequests;
    }

    private static class UserAccessRecord {
        long lastAccessTime;
        int accessCount;

        UserAccessRecord(long lastAccessTime, int accessCount) {
            this.lastAccessTime = lastAccessTime;
            this.accessCount = accessCount;
        }
    }

    public static class Factory
    implements ResourcePackHostFactory {
        @Override
        public ResourcePackHost create(Map<String, Object> arguments) {
            Map<String, Object> proxySetting;
            String accessKeySecret;
            String accessKeyId;
            boolean useEnv = (Boolean)arguments.getOrDefault("use-environment-variables", false);
            String endpoint = Optional.ofNullable(arguments.get("endpoint")).map(String::valueOf).orElse(null);
            if (endpoint == null || endpoint.isEmpty()) {
                throw new LocalizedException("warning.config.host.s3.missing_endpoint", new String[0]);
            }
            String protocol = arguments.getOrDefault("protocol", "https").toString();
            boolean usePathStyle = (Boolean)arguments.getOrDefault("path-style", false);
            String bucket = Optional.ofNullable(arguments.get("bucket")).map(String::valueOf).orElse(null);
            if (bucket == null || bucket.isEmpty()) {
                throw new LocalizedException("warning.config.host.s3.missing_bucket", new String[0]);
            }
            String region = arguments.getOrDefault("region", "auto").toString();
            String string = accessKeyId = useEnv ? System.getenv("CE_S3_ACCESS_KEY_ID") : (String)Optional.ofNullable(arguments.get("access-key-id")).map(String::valueOf).orElse(null);
            if (accessKeyId == null || accessKeyId.isEmpty()) {
                throw new LocalizedException("warning.config.host.s3.missing_access_key", new String[0]);
            }
            String string2 = accessKeySecret = useEnv ? System.getenv("CE_S3_ACCESS_KEY_SECRET") : (String)Optional.ofNullable(arguments.get("access-key-secret")).map(String::valueOf).orElse(null);
            if (accessKeySecret == null || accessKeySecret.isEmpty()) {
                throw new LocalizedException("warning.config.host.s3.missing_secret", new String[0]);
            }
            String uploadPath = arguments.getOrDefault("upload-path", "craftengine/resource_pack.zip").toString();
            if (uploadPath == null || uploadPath.isEmpty()) {
                throw new LocalizedException("warning.config.host.s3.missing_upload_path", new String[0]);
            }
            boolean useLegacySignature = (Boolean)arguments.getOrDefault("use-legacy-signature", true);
            Duration validity = Duration.ofSeconds(((Integer)arguments.getOrDefault("validity", 10)).intValue());
            Map<String, Object> cdn = MiscUtils.castToMap(arguments.get("cdn"), true);
            String cdnDomain = null;
            String cdnProtocol = "https";
            if (cdn != null) {
                cdnDomain = Optional.ofNullable(cdn.get("domain")).map(String::valueOf).orElse(null);
                cdnProtocol = cdn.getOrDefault("protocol", "https").toString();
            }
            AwsBasicCredentials credentials = AwsBasicCredentials.create((String)accessKeyId, (String)accessKeySecret);
            S3AsyncClientBuilder s3AsyncClientBuilder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().endpointOverride(URI.create(protocol + "://" + endpoint))).region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials))).serviceConfiguration(b2 -> b2.pathStyleAccessEnabled(Boolean.valueOf(usePathStyle)));
            if (useLegacySignature) {
                s3AsyncClientBuilder.overrideConfiguration(b2 -> b2.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)AwsS3V4Signer.create()));
            }
            if ((proxySetting = MiscUtils.castToMap(arguments.get("proxy"), true)) != null) {
                String host = ResourceConfigUtils.requireNonEmptyStringOrThrow(proxySetting.get("host"), () -> new LocalizedException("warning.config.host.proxy.missing_host", new String[0]));
                int port = ResourceConfigUtils.getAsInt(proxySetting.get("port"), "port");
                if (port <= 0 || port > 65535) {
                    throw new LocalizedException("warning.config.host.proxy.missing_port", new String[0]);
                }
                String scheme = ResourceConfigUtils.requireNonEmptyStringOrThrow(proxySetting.get("scheme"), () -> new LocalizedException("warning.config.host.proxy.missing_scheme", new String[0]));
                String username = Optional.ofNullable(proxySetting.get("username")).map(String::valueOf).orElse(null);
                String password = Optional.ofNullable(proxySetting.get("password")).map(String::valueOf).orElse(null);
                ProxyConfiguration.Builder builder = ProxyConfiguration.builder().host(host).port(port).scheme(scheme);
                if (username != null) {
                    builder.username(username);
                }
                if (password != null) {
                    builder.password(password);
                }
                SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().proxyConfiguration((ProxyConfiguration)builder.build()).build();
                s3AsyncClientBuilder.httpClient(httpClient);
            }
            S3AsyncClient s3AsyncClient = (S3AsyncClient)s3AsyncClientBuilder.build();
            S3Presigner preSigner = S3Presigner.builder().endpointOverride(URI.create(protocol + "://" + endpoint)).region(Region.of((String)region)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials)).build();
            Map<String, Object> rateMap = MiscUtils.castToMap(arguments.get("rate-map"), true);
            int maxRequests = -1;
            int resetInterval = -1;
            if (rateMap != null) {
                maxRequests = ResourceConfigUtils.getAsInt(rateMap.getOrDefault("max-requests", 5), "max-requests");
                resetInterval = ResourceConfigUtils.getAsInt(rateMap.getOrDefault("reset-interval", 20), "reset-interval") * 1000;
            }
            return new S3Host(s3AsyncClient, preSigner, bucket, uploadPath, cdnDomain, cdnProtocol, validity, maxRequests, resetInterval);
        }
    }
}

