/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.pack.ResourceLocation;
import net.momirealms.craftengine.core.pack.model.ItemModel;
import net.momirealms.craftengine.core.pack.model.ItemModelFactory;
import net.momirealms.craftengine.core.pack.model.ItemModelReader;
import net.momirealms.craftengine.core.pack.model.ItemModels;
import net.momirealms.craftengine.core.pack.model.generation.ModelGeneration;
import net.momirealms.craftengine.core.pack.model.tint.Tint;
import net.momirealms.craftengine.core.pack.model.tint.Tints;
import net.momirealms.craftengine.core.pack.revision.Revision;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MinecraftVersion;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import org.jetbrains.annotations.Nullable;

public class BaseItemModel
implements ItemModel {
    public static final Factory FACTORY = new Factory();
    public static final Reader READER = new Reader();
    private final String path;
    private final List<Tint> tints;
    private final ModelGeneration modelGeneration;

    public BaseItemModel(String path, List<Tint> tints, @Nullable ModelGeneration modelGeneration) {
        this.path = path;
        this.tints = tints;
        this.modelGeneration = modelGeneration;
    }

    public List<Tint> tints() {
        return this.tints;
    }

    public String path() {
        return this.path;
    }

    @Override
    public JsonObject apply(MinecraftVersion version) {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type().toString());
        json.addProperty("model", this.path);
        if (!this.tints.isEmpty()) {
            JsonArray array = new JsonArray();
            for (Tint tint : this.tints) {
                array.add((JsonElement)tint.get());
            }
            json.add("tints", (JsonElement)array);
        }
        return json;
    }

    @Override
    public Key type() {
        return ItemModels.MODEL;
    }

    @Override
    public List<ModelGeneration> modelsToGenerate() {
        if (this.modelGeneration == null) {
            return List.of();
        }
        return List.of(this.modelGeneration);
    }

    @Override
    public List<Revision> revisions() {
        return List.of();
    }

    public static class Factory
    implements ItemModelFactory {
        @Override
        public ItemModel create(Map<String, Object> arguments) {
            String modelPath = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("path"), "warning.config.item.model.base.missing_path");
            if (!ResourceLocation.isValid(modelPath)) {
                throw new LocalizedResourceConfigException("warning.config.item.model.base.invalid_path", modelPath);
            }
            Map<String, Object> generation = MiscUtils.castToMap(arguments.get("generation"), true);
            ModelGeneration modelGeneration = null;
            if (generation != null) {
                modelGeneration = ModelGeneration.of(Key.of(modelPath), generation);
            }
            if (arguments.containsKey("tints")) {
                ArrayList<Tint> tints = new ArrayList<Tint>();
                List tintList = (List)arguments.get("tints");
                for (Map tint : tintList) {
                    tints.add(Tints.fromMap(tint));
                }
                return new BaseItemModel(modelPath, tints, modelGeneration);
            }
            return new BaseItemModel(modelPath, List.of(), modelGeneration);
        }
    }

    public static class Reader
    implements ItemModelReader {
        @Override
        public ItemModel read(JsonObject json) {
            String model = json.get("model").getAsString();
            if (json.has("tints")) {
                JsonArray array = json.getAsJsonArray("tints");
                ArrayList<Tint> tints = new ArrayList<Tint>(array.size());
                for (JsonElement element : array) {
                    if (element instanceof JsonObject) {
                        JsonObject jo = (JsonObject)element;
                        tints.add(Tints.fromJson(jo));
                        continue;
                    }
                    throw new IllegalArgumentException("tint is expected to be a json object");
                }
                return new BaseItemModel(model, tints, null);
            }
            return new BaseItemModel(model, List.of(), null);
        }
    }
}

