/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyOverridesModel
implements Comparable<LegacyOverridesModel> {
    private final Map<String, Object> predicate;
    private final String model;
    private final int customModelData;

    public LegacyOverridesModel(@Nullable Map<String, Object> predicate, @NotNull String model, int customModelData) {
        this.predicate = predicate == null ? new HashMap() : predicate;
        this.model = model;
        this.customModelData = customModelData;
        if (customModelData > 0 && !this.predicate.containsKey("custom_model_data")) {
            this.predicate.put("custom_model_data", customModelData);
        }
    }

    public Map<String, Object> predicate() {
        return this.predicate;
    }

    public boolean hasPredicate() {
        return this.predicate != null && !this.predicate.isEmpty();
    }

    public String model() {
        return this.model;
    }

    public JsonObject toLegacyPredicateElement() {
        JsonObject json = new JsonObject();
        JsonObject predicateJson = new JsonObject();
        if (this.predicate != null && !this.predicate.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.predicate.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    predicateJson.addProperty(entry.getKey(), b);
                    continue;
                }
                object = entry.getValue();
                if (object instanceof Number) {
                    Number n = (Number)object;
                    predicateJson.addProperty(entry.getKey(), n);
                    continue;
                }
                object = entry.getValue();
                if (!(object instanceof String)) continue;
                String s = (String)object;
                predicateJson.addProperty(entry.getKey(), s);
            }
            json.add("predicate", (JsonElement)predicateJson);
        }
        json.addProperty("model", this.model);
        return json;
    }

    public int customModelData() {
        return this.customModelData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyOverridesModel that = (LegacyOverridesModel)o;
        return this.customModelData == that.customModelData && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        int result = this.predicate.hashCode();
        result = 31 * result + Objects.hashCode(this.model);
        result = 31 * result + this.customModelData;
        return result;
    }

    public String toString() {
        return "LegacyOverridesModel{predicate=" + String.valueOf(this.predicate) + ", model='" + this.model + "', custom-model-data=" + this.customModelData + "}";
    }

    @Override
    public int compareTo(@NotNull LegacyOverridesModel o) {
        if (this.customModelData != o.customModelData) {
            return this.customModelData - o.customModelData;
        }
        if (this.predicate.size() != o.predicate.size()) {
            return this.predicate.size() - o.predicate.size();
        }
        for (Map.Entry<String, Object> entry : this.predicate.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!o.predicate.containsKey(key)) {
                return 1;
            }
            Object otherValue = o.predicate.get(key);
            int valueComparison = this.compareValues(value, otherValue);
            if (valueComparison == 0) continue;
            return valueComparison;
        }
        return 0;
    }

    private int compareValues(Object value1, Object value2) {
        if (value1 instanceof Comparable) {
            Comparable c1 = (Comparable)value1;
            if (value2 instanceof Comparable) {
                Comparable c2 = (Comparable)value2;
                return c1.compareTo(c2);
            }
        }
        return value1.equals(value2) ? 0 : -1;
    }
}

