/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.pack.obfuscation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.momirealms.craftengine.core.pack.obfuscation.ObfA;
import net.momirealms.craftengine.core.pack.obfuscation.ObfB;

public class ObfC {
    private String _metaIdentifier;
    private String _characterSet;
    private final List<String> _segmentCache = new ArrayList<String>();
    private final Set<String> _existingSegments = new HashSet<String>();
    private final Set<String> _registeredPatterns = new HashSet<String>();
    private static final Random _randomizer = new Random();
    private static final Gson _jsonProcessor = new Gson();

    protected ObfC(String textureCatalog, String namingScheme) {
        ObfC.validateNamingPattern(namingScheme);
        this._metaIdentifier = textureCatalog;
        this._characterSet = ObfC.normalizeCharset(namingScheme);
    }

    protected ObfC() {
        this("ce", ObfC.generateDefaultCharset());
    }

    private static void validateNamingPattern(String pattern) {
        if (pattern == null || !pattern.matches("^[a-z0-9_.-]+$")) {
            throw new IllegalArgumentException("Invalid naming scheme");
        }
    }

    private static String normalizeCharset(String input) {
        return input.toLowerCase(Locale.ENGLISH);
    }

    private static String generateDefaultCharset() {
        char[] chars = new char[26];
        for (int i = 0; i < 26; ++i) {
            chars[i] = (char)(97 + i);
        }
        return new String(chars);
    }

    protected String randomName() {
        return this._metaIdentifier;
    }

    protected String string() {
        return this._characterSet;
    }

    protected void setRandomName(String identifier) {
        this._metaIdentifier = identifier;
    }

    protected void setString(String charset) {
        this._characterSet = charset;
    }

    public String getRandomNamespace(int securityLevel, int poolSize) {
        return securityLevel == 3 ? this.generateUniqueSegment() : this.manageSegmentPool(poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String manageSegmentPool(int poolSize) {
        List<String> list = this._segmentCache;
        synchronized (list) {
            while (this._segmentCache.size() < poolSize) {
                this._segmentCache.add(this.generateUniqueSegment());
            }
            return this._segmentCache.get(_randomizer.nextInt(poolSize));
        }
    }

    private String generateUniqueSegment() {
        StringBuilder segment = new StringBuilder();
        do {
            segment.setLength(0);
            for (int i = 0; i < 3 + _randomizer.nextInt(3); ++i) {
                segment.append(this.randomChar());
            }
        } while (this._existingSegments.contains(segment.toString()));
        this._existingSegments.add(segment.toString());
        return segment.toString();
    }

    private char randomChar() {
        return this._characterSet.charAt(_randomizer.nextInt(this._characterSet.length()));
    }

    private String generateObfuscatedPath(int complexity, boolean enableTraps, boolean excludeCatalog) {
        StringBuilder pathBuilder = new StringBuilder();
        if (!excludeCatalog) {
            pathBuilder.append(this._metaIdentifier).append('/');
        }
        int remainingDepth = complexity - pathBuilder.length();
        boolean trapInserted = false;
        while (remainingDepth > 0) {
            if (enableTraps && !trapInserted && this.shouldInsertTrap(remainingDepth)) {
                pathBuilder.append(".../");
                remainingDepth -= 4;
                trapInserted = true;
                continue;
            }
            int segmentLength = Math.min(2 + _randomizer.nextInt(3), remainingDepth);
            this.appendRandomSegment(pathBuilder, segmentLength);
            remainingDepth -= segmentLength + 1;
        }
        this.validatePathUniqueness(pathBuilder.toString());
        return pathBuilder.toString();
    }

    private boolean shouldInsertTrap(int remaining) {
        return _randomizer.nextInt(remaining / 3 + 1) == 0;
    }

    private void appendRandomSegment(StringBuilder builder, int length) {
        for (int i = 0; i < length; ++i) {
            builder.append(this.randomChar());
        }
        builder.append('/');
    }

    private void validatePathUniqueness(String path) {
        if (this._registeredPatterns.contains(path)) {
            throw new IllegalStateException("Path collision detected");
        }
        this._registeredPatterns.add(path);
    }

    public ObfB getRandomResourceKey(int complexity, ObfB template, int securityLevel, int poolSize, boolean enableTraps) {
        boolean requiresMetadata = template.\u5230\u5e95\u8c01\u624d\u662f\u5976\u9f99();
        boolean excludeCatalog = template.\u6211\u662f\u8c01();
        ObfA typeDescriptor = template.\u4f60\u6ca1\u4e8b\u5427();
        int adjustedComplexity = complexity - (requiresMetadata ? 14 : 7) - typeDescriptor.jntm().length() - typeDescriptor.rkwd().length();
        String namespace = securityLevel == 1 ? template.\u8c01\u662f\u5976\u9f99() : this.getRandomNamespace(securityLevel, poolSize);
        adjustedComplexity -= namespace.length() + 2;
        try {
            return ObfB.\u6709\u6b3e\u6e38\u620f\u8d8a\u5927\u8d8a\u5e74\u8f7b(namespace, typeDescriptor);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new RuntimeException("Please increase the value of resource-pack.obfuscation.path-length in config.yml: " + String.valueOf(e));
        }
    }

    public void \u5bb6\u4eba\u4eec\u8c01\u61c2\u554a(Path baseDir) throws IOException {
        Path atlasConfig = baseDir.resolve("assets/minecraft/atlases/blocks.json");
        Map<String, Object> configData = this.createAtlasConfiguration();
        if (Files.notExists(atlasConfig, new LinkOption[0])) {
            this.initializeAtlasConfig(atlasConfig, configData);
        } else {
            this.updateExistingConfig(atlasConfig, configData);
        }
    }

    private Map<String, Object> createAtlasConfiguration() {
        return Map.of("sources", Collections.singletonList(Map.of("type", "directory", "source", this._metaIdentifier, "prefix", this._metaIdentifier + "/")));
    }

    private void initializeAtlasConfig(Path configPath, Map<String, Object> data) throws IOException {
        Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(configPath.toFile()));){
            _jsonProcessor.toJson(data, (Type)writer);
        }
    }

    private void updateExistingConfig(Path configPath, Map<String, Object> newData) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(configPath.toFile()));){
            JsonObject existing = (JsonObject)_jsonProcessor.fromJson(reader, JsonObject.class);
            JsonArray sources = existing.getAsJsonArray("sources");
            JsonObject newSource = _jsonProcessor.toJsonTree(newData.get("sources")).getAsJsonArray().get(0).getAsJsonObject();
            if (!this.containsSource(sources, newSource)) {
                sources.add((JsonElement)newSource);
                this.writeUpdatedConfig(configPath, existing);
            }
        }
        catch (Exception e) {
            this.rewriteConfigFile(configPath, newData);
        }
    }

    private boolean containsSource(JsonArray sources, JsonObject target) {
        return sources.asList().stream().anyMatch(element -> element.equals(target));
    }

    private void writeUpdatedConfig(Path path, JsonObject data) throws IOException {
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(path.toFile()));){
            _jsonProcessor.toJson((JsonElement)data, writer);
        }
    }

    private void rewriteConfigFile(Path path, Map<String, Object> data) throws IOException {
        try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(path.toFile()));){
            _jsonProcessor.toJson(data, (Type)writer);
        }
    }

    private static class ConfigurationException
    extends RuntimeException {
        ConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

