/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.momirealms.craftengine.core.advancement.AdvancementManager;
import net.momirealms.craftengine.core.block.BlockManager;
import net.momirealms.craftengine.core.entity.furniture.FurnitureManager;
import net.momirealms.craftengine.core.entity.projectile.ProjectileManager;
import net.momirealms.craftengine.core.font.FontManager;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.item.recipe.RecipeManager;
import net.momirealms.craftengine.core.item.recipe.network.legacy.LegacyRecipeTypes;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.RecipeDisplayTypes;
import net.momirealms.craftengine.core.item.recipe.network.modern.display.slot.SlotDisplayTypes;
import net.momirealms.craftengine.core.loot.VanillaLootManager;
import net.momirealms.craftengine.core.pack.PackManager;
import net.momirealms.craftengine.core.plugin.Platform;
import net.momirealms.craftengine.core.plugin.Plugin;
import net.momirealms.craftengine.core.plugin.classpath.ClassPathAppender;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.command.sender.SenderFactory;
import net.momirealms.craftengine.core.plugin.compatibility.CompatibilityManager;
import net.momirealms.craftengine.core.plugin.compatibility.PluginTaskRegistry;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.config.template.TemplateManager;
import net.momirealms.craftengine.core.plugin.config.template.TemplateManagerImpl;
import net.momirealms.craftengine.core.plugin.context.GlobalVariableManager;
import net.momirealms.craftengine.core.plugin.dependency.Dependencies;
import net.momirealms.craftengine.core.plugin.dependency.Dependency;
import net.momirealms.craftengine.core.plugin.dependency.DependencyManager;
import net.momirealms.craftengine.core.plugin.dependency.DependencyManagerImpl;
import net.momirealms.craftengine.core.plugin.gui.GuiManager;
import net.momirealms.craftengine.core.plugin.gui.category.ItemBrowserManager;
import net.momirealms.craftengine.core.plugin.gui.category.ItemBrowserManagerImpl;
import net.momirealms.craftengine.core.plugin.locale.TranslationManager;
import net.momirealms.craftengine.core.plugin.logger.PluginLogger;
import net.momirealms.craftengine.core.plugin.logger.filter.DisconnectLogFilter;
import net.momirealms.craftengine.core.plugin.logger.filter.LogFilter;
import net.momirealms.craftengine.core.plugin.network.NetworkManager;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerAdapter;
import net.momirealms.craftengine.core.sound.SoundManager;
import net.momirealms.craftengine.core.world.WorldManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class CraftEngine
implements Plugin {
    private static CraftEngine instance;
    protected PluginLogger logger;
    protected Config config;
    protected Platform platform;
    protected ClassPathAppender sharedClassPathAppender;
    protected ClassPathAppender privateClassPathAppender;
    protected DependencyManager dependencyManager;
    protected SchedulerAdapter<?> scheduler;
    protected NetworkManager networkManager;
    protected FontManager fontManager;
    protected PackManager packManager;
    protected ItemManager<?> itemManager;
    protected RecipeManager<?> recipeManager;
    protected BlockManager blockManager;
    protected TranslationManager translationManager;
    protected WorldManager worldManager;
    protected FurnitureManager furnitureManager;
    protected CraftEngineCommandManager<?> commandManager;
    protected SenderFactory<? extends Plugin, ?> senderFactory;
    protected TemplateManager templateManager;
    protected ItemBrowserManager itemBrowserManager;
    protected GuiManager guiManager;
    protected SoundManager soundManager;
    protected VanillaLootManager vanillaLootManager;
    protected AdvancementManager advancementManager;
    protected CompatibilityManager compatibilityManager;
    protected GlobalVariableManager globalVariableManager;
    protected ProjectileManager projectileManager;
    private final PluginTaskRegistry preLoadTaskRegistry = new PluginTaskRegistry();
    private final PluginTaskRegistry postLoadTaskRegistry = new PluginTaskRegistry();
    private final Consumer<CraftEngine> reloadEventDispatcher;
    private boolean isReloading;
    private boolean isInitializing;
    private String buildByBit = "%%__BUILTBYBIT__%%";
    private String polymart = "%%__POLYMART__%%";
    private String time = "%%__TIMESTAMP__%%";
    private String user = "%%__USER__%%";
    private String username = "%%__USERNAME__%%";

    protected CraftEngine(Consumer<CraftEngine> reloadEventDispatcher) {
        instance = this;
        this.reloadEventDispatcher = reloadEventDispatcher;
    }

    public static CraftEngine instance() {
        if (instance == null) {
            throw new IllegalStateException("CraftEngine has not been initialized");
        }
        return instance;
    }

    protected void onPluginLoad() {
        RecipeDisplayTypes.init();
        SlotDisplayTypes.init();
        LegacyRecipeTypes.init();
        ((Logger)LogManager.getRootLogger()).addFilter((Filter)new LogFilter());
        ((Logger)LogManager.getRootLogger()).addFilter((Filter)new DisconnectLogFilter());
        this.config.load();
    }

    public CompletableFuture<ReloadResult> reloadPlugin(Executor asyncExecutor, Executor syncExecutor, boolean reloadRecipe) {
        CompletableFuture<ReloadResult> future = new CompletableFuture<ReloadResult>();
        asyncExecutor.execute(() -> {
            long asyncTime = -1L;
            try {
                if (this.isReloading) {
                    future.complete(ReloadResult.failure());
                    return;
                }
                this.isReloading = true;
                long time1 = System.currentTimeMillis();
                this.config.load();
                this.translationManager.reload();
                this.templateManager.reload();
                this.globalVariableManager.reload();
                this.furnitureManager.reload();
                this.fontManager.reload();
                this.itemManager.reload();
                this.soundManager.reload();
                this.itemBrowserManager.reload();
                this.blockManager.reload();
                this.worldManager.reload();
                this.vanillaLootManager.reload();
                this.guiManager.reload();
                this.packManager.reload();
                this.advancementManager.reload();
                this.projectileManager.reload();
                if (reloadRecipe) {
                    this.recipeManager.reload();
                }
                try {
                    this.packManager.loadResources(reloadRecipe);
                }
                catch (Exception e) {
                    this.logger().warn("Failed to load resources folder", e);
                }
                this.itemManager.delayedLoad();
                this.blockManager.delayedLoad();
                this.translationManager.delayedLoad();
                this.furnitureManager.delayedLoad();
                this.itemBrowserManager.delayedLoad();
                this.fontManager.delayedLoad();
                this.advancementManager.delayedLoad();
                if (reloadRecipe) {
                    this.recipeManager.delayedLoad();
                }
                long time2 = System.currentTimeMillis();
                asyncTime = time2 - time1;
            }
            finally {
                long finalAsyncTime = asyncTime;
                syncExecutor.execute(() -> {
                    try {
                        long time3 = System.currentTimeMillis();
                        this.soundManager.runDelayedSyncTasks();
                        if (reloadRecipe) {
                            this.recipeManager.runDelayedSyncTasks();
                        }
                        long time4 = System.currentTimeMillis();
                        long syncTime = time4 - time3;
                        this.reloadEventDispatcher.accept(this);
                        future.complete(ReloadResult.success(finalAsyncTime, syncTime));
                    }
                    finally {
                        this.isReloading = false;
                    }
                });
            }
        });
        return future;
    }

    protected void onPluginEnable() {
        this.isInitializing = true;
        this.networkManager.init();
        this.templateManager = new TemplateManagerImpl();
        this.globalVariableManager = new GlobalVariableManager();
        this.itemBrowserManager = new ItemBrowserManagerImpl(this);
        this.commandManager.registerDefaultFeatures();
        this.scheduler.sync().runDelayed(() -> {
            this.preLoadTaskRegistry.executeTasks();
            this.registerDefaultParsers();
            this.itemManager.delayedInit();
            this.blockManager.delayedInit();
            this.guiManager.delayedInit();
            this.recipeManager.delayedInit();
            this.packManager.delayedInit();
            this.fontManager.delayedInit();
            this.vanillaLootManager.delayedInit();
            this.advancementManager.delayedInit();
            this.compatibilityManager.onDelayedEnable();
            try {
                this.reloadPlugin(Runnable::run, Runnable::run, true);
            }
            catch (Exception e) {
                this.logger.warn("Failed to reload plugin on enable stage", e);
            }
            this.projectileManager.delayedInit();
            this.worldManager.delayedInit();
            this.furnitureManager.delayedInit();
            this.platformDelayedEnable();
            this.isInitializing = false;
            this.postLoadTaskRegistry.executeTasks();
            this.scheduler.executeAsync(() -> this.packManager.initCachedAssets());
        });
    }

    protected void onPluginDisable() {
        if (this.networkManager != null) {
            this.networkManager.disable();
        }
        if (this.fontManager != null) {
            this.fontManager.disable();
        }
        if (this.advancementManager != null) {
            this.advancementManager.disable();
        }
        if (this.packManager != null) {
            this.packManager.disable();
        }
        if (this.itemManager != null) {
            this.itemManager.disable();
        }
        if (this.blockManager != null) {
            this.blockManager.disable();
        }
        if (this.furnitureManager != null) {
            this.furnitureManager.disable();
        }
        if (this.templateManager != null) {
            this.templateManager.disable();
        }
        if (this.worldManager != null) {
            this.worldManager.disable();
        }
        if (this.recipeManager != null) {
            this.recipeManager.disable();
        }
        if (this.itemBrowserManager != null) {
            this.itemBrowserManager.disable();
        }
        if (this.guiManager != null) {
            this.guiManager.disable();
        }
        if (this.soundManager != null) {
            this.soundManager.disable();
        }
        if (this.vanillaLootManager != null) {
            this.vanillaLootManager.disable();
        }
        if (this.translationManager != null) {
            this.translationManager.disable();
        }
        if (this.globalVariableManager != null) {
            this.globalVariableManager.disable();
        }
        if (this.projectileManager != null) {
            this.projectileManager.disable();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownScheduler();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownExecutor();
        }
        if (this.commandManager != null) {
            this.commandManager.unregisterFeatures();
        }
        if (this.senderFactory != null) {
            this.senderFactory.close();
        }
        if (this.dependencyManager != null) {
            this.dependencyManager.close();
        }
    }

    protected void registerDefaultParsers() {
        this.packManager.registerConfigSectionParser(this.templateManager.parser());
        this.packManager.registerConfigSectionParser(this.globalVariableManager.parser());
        this.packManager.registerConfigSectionParsers(this.fontManager.parsers());
        this.packManager.registerConfigSectionParsers(this.itemManager.parsers());
        this.packManager.registerConfigSectionParser(this.furnitureManager.parser());
        this.packManager.registerConfigSectionParser(this.blockManager.parser());
        this.packManager.registerConfigSectionParser(this.recipeManager.parser());
        this.packManager.registerConfigSectionParser(this.itemBrowserManager.parser());
        this.packManager.registerConfigSectionParsers(this.translationManager.parsers());
        this.packManager.registerConfigSectionParsers(this.soundManager.parsers());
        this.packManager.registerConfigSectionParser(this.vanillaLootManager.parser());
        this.packManager.registerConfigSectionParser(this.advancementManager.parser());
    }

    public void applyDependencies() {
        this.dependencyManager = new DependencyManagerImpl(this);
        ArrayList<Dependency> dependenciesToLoad = new ArrayList<Dependency>();
        dependenciesToLoad.addAll(this.commonDependencies());
        dependenciesToLoad.addAll(this.platformDependencies());
        this.dependencyManager.loadDependencies(dependenciesToLoad);
    }

    protected abstract void platformDelayedEnable();

    protected abstract List<Dependency> platformDependencies();

    protected List<Dependency> commonDependencies() {
        return List.of(Dependencies.BSTATS_BASE, Dependencies.CAFFEINE, Dependencies.GEANTY_REF, Dependencies.CLOUD_CORE, Dependencies.CLOUD_SERVICES, Dependencies.GSON, Dependencies.COMMONS_IO, Dependencies.COMMONS_LANG3, Dependencies.COMMONS_IMAGING, Dependencies.ZSTD, Dependencies.BYTE_BUDDY, Dependencies.BYTE_BUDDY_AGENT, Dependencies.SNAKE_YAML, Dependencies.BOOSTED_YAML, Dependencies.OPTION, Dependencies.EXAMINATION_API, Dependencies.EXAMINATION_STRING, Dependencies.ADVENTURE_KEY, Dependencies.ADVENTURE_API, Dependencies.ADVENTURE_NBT, Dependencies.MINIMESSAGE, Dependencies.TEXT_SERIALIZER_COMMONS, Dependencies.TEXT_SERIALIZER_LEGACY, Dependencies.TEXT_SERIALIZER_GSON, Dependencies.TEXT_SERIALIZER_GSON_LEGACY, Dependencies.TEXT_SERIALIZER_JSON, Dependencies.AHO_CORASICK, Dependencies.LZ4, Dependencies.EVALEX, Dependencies.NETTY_HTTP, Dependencies.JIMFS);
    }

    @Override
    public <W> SchedulerAdapter<W> scheduler() {
        return this.scheduler;
    }

    @Override
    public ClassPathAppender sharedClassPathAppender() {
        return this.sharedClassPathAppender;
    }

    @Override
    public ClassPathAppender privateClassPathAppender() {
        return this.privateClassPathAppender;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public PluginLogger logger() {
        return this.logger;
    }

    @Override
    public boolean isReloading() {
        return this.isReloading;
    }

    @Override
    public boolean isInitializing() {
        return this.isInitializing;
    }

    @Override
    public DependencyManager dependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public <T> ItemManager<T> itemManager() {
        return this.itemManager;
    }

    @Override
    public BlockManager blockManager() {
        return this.blockManager;
    }

    @Override
    public NetworkManager networkManager() {
        return this.networkManager;
    }

    @Override
    public FontManager fontManager() {
        return this.fontManager;
    }

    @Override
    public AdvancementManager advancementManager() {
        return this.advancementManager;
    }

    @Override
    public TranslationManager translationManager() {
        return this.translationManager;
    }

    @Override
    public TemplateManager templateManager() {
        return this.templateManager;
    }

    @Override
    public FurnitureManager furnitureManager() {
        return this.furnitureManager;
    }

    @Override
    public PackManager packManager() {
        return this.packManager;
    }

    @Override
    public <T> RecipeManager<T> recipeManager() {
        return this.recipeManager;
    }

    @Override
    public <P extends Plugin, C> SenderFactory<P, C> senderFactory() {
        return this.senderFactory;
    }

    @Override
    public WorldManager worldManager() {
        return this.worldManager;
    }

    @Override
    public ItemBrowserManager itemBrowserManager() {
        return this.itemBrowserManager;
    }

    @Override
    public GuiManager guiManager() {
        return this.guiManager;
    }

    @Override
    public SoundManager soundManager() {
        return this.soundManager;
    }

    @Override
    public VanillaLootManager vanillaLootManager() {
        return this.vanillaLootManager;
    }

    @Override
    public CompatibilityManager compatibilityManager() {
        return this.compatibilityManager;
    }

    @Override
    public GlobalVariableManager globalVariableManager() {
        return this.globalVariableManager;
    }

    @Override
    public ProjectileManager projectileManager() {
        return this.projectileManager;
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @ApiStatus.Experimental
    public PluginTaskRegistry preLoadTaskRegistry() {
        return this.preLoadTaskRegistry;
    }

    @ApiStatus.Experimental
    public PluginTaskRegistry postLoadTaskRegistry() {
        return this.postLoadTaskRegistry;
    }

    public record ReloadResult(boolean success, long asyncTime, long syncTime) {
        static ReloadResult failure() {
            return new ReloadResult(false, -1L, -1L);
        }

        static ReloadResult success(long asyncTime, long syncTime) {
            return new ReloadResult(true, asyncTime, syncTime);
        }
    }
}

