/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.compatibility;

import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.plugin.compatibility.PluginTask;

public final class PluginTaskRegistry {
    private final Node head = new Node(null);
    private final Node tail = new Node(null);
    private final Map<String, Node> pluginNodeMap = new HashMap<String, Node>();

    public PluginTaskRegistry() {
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    public void registerTask(PluginTask task) {
        PluginTask.Priority priority = task.priority();
        Node newNode = new Node(task);
        String pluginName = task.plugin();
        if (this.pluginNodeMap.containsKey(pluginName)) {
            throw new IllegalArgumentException("Duplicate task for plugin: " + pluginName);
        }
        switch (priority.position()) {
            case HEAD: {
                this.insertAfter(this.head, newNode);
                break;
            }
            case TAIL: {
                this.insertBefore(this.tail, newNode);
                break;
            }
            case BEFORE_PLUGIN: {
                Node targetBefore = this.pluginNodeMap.get(priority.relativePlugin());
                if (targetBefore == null) {
                    throw new IllegalArgumentException("Target plugin not found: " + priority.relativePlugin());
                }
                this.insertBefore(targetBefore, newNode);
                break;
            }
            case AFTER_PLUGIN: {
                Node targetAfter = this.pluginNodeMap.get(priority.relativePlugin());
                if (targetAfter == null) {
                    throw new IllegalArgumentException("Target plugin not found: " + priority.relativePlugin());
                }
                this.insertAfter(targetAfter, newNode);
            }
        }
        this.pluginNodeMap.put(pluginName, newNode);
    }

    private void insertAfter(Node existing, Node newNode) {
        newNode.next = existing.next;
        newNode.prev = existing;
        existing.next.prev = newNode;
        existing.next = newNode;
    }

    private void insertBefore(Node existing, Node newNode) {
        newNode.prev = existing.prev;
        newNode.next = existing;
        existing.prev.next = newNode;
        existing.prev = newNode;
    }

    public void executeTasks() {
        try {
            Node current = this.head.next;
            while (current != this.tail) {
                current.task.task().run();
                current = current.next;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getExecutionOrder() {
        StringBuilder sb = new StringBuilder();
        Node current = this.head.next;
        while (current != this.tail) {
            sb.append(current.task.plugin());
            if (current.next != this.tail) {
                sb.append(" -> ");
            }
            current = current.next;
        }
        return sb.toString();
    }

    private static class Node {
        final PluginTask task;
        Node prev;
        Node next;

        Node(PluginTask task) {
            this.task = task;
        }
    }
}

