/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.AdditionalParameterProvider;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.RandomUtils;

public class CommonParameterProvider
implements AdditionalParameterProvider {
    private double lastRandom = -1.0;
    private static final Map<ContextKey<?>, Function<CommonParameterProvider, Object>> CONTEXT_FUNCTIONS = new HashMap();

    @Override
    public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter) {
        return Optional.ofNullable(CONTEXT_FUNCTIONS.get(parameter)).map(f -> f.apply(this));
    }

    static {
        CONTEXT_FUNCTIONS.put(DirectContextParameters.RANDOM, f -> {
            f.lastRandom = RandomUtils.generateRandomDouble(0.0, 1.0);
            return f.lastRandom;
        });
        CONTEXT_FUNCTIONS.put(DirectContextParameters.LAST_RANDOM, f -> {
            if (f.lastRandom == -1.0) {
                f.lastRandom = RandomUtils.generateRandomDouble(0.0, 1.0);
            }
            return f.lastRandom;
        });
    }
}

