/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextHolder {
    @Deprecated(forRemoval=true, since="0.0.63")
    public static final ContextHolder EMPTY = ContextHolder.builder().immutable(true).build();
    protected final Map<ContextKey<?>, Supplier<Object>> params;
    private final boolean immutable;

    public ContextHolder(Map<ContextKey<?>, Supplier<Object>> params, boolean immutable) {
        this.params = immutable ? ImmutableMap.copyOf(params) : new HashMap(params);
        this.immutable = immutable;
    }

    public ContextHolder(Map<ContextKey<?>, Supplier<Object>> params) {
        this.params = new HashMap(params);
        this.immutable = true;
    }

    @NotNull
    public static ContextHolder empty() {
        return ContextHolder.builder().build();
    }

    public boolean immutable() {
        return this.immutable;
    }

    public boolean has(ContextKey<?> key) {
        return this.params.containsKey(key);
    }

    public <T> ContextHolder withParameter(ContextKey<T> parameter, T value) {
        this.params.put(parameter, SimpleSupplier.of(value));
        return this;
    }

    public <T> ContextHolder withParameter(ContextKey<T> parameter, Supplier<T> value) {
        this.params.put(parameter, value);
        return this;
    }

    public <T> ContextHolder withOptionalParameter(ContextKey<T> parameter, @Nullable T value) {
        if (value == null) {
            this.params.remove(parameter);
        } else {
            this.params.put(parameter, SimpleSupplier.of(value));
        }
        return this;
    }

    public <T> T getOrThrow(ContextKey<T> parameter) {
        Supplier<Object> object = this.params.get(parameter);
        if (object == null) {
            throw new NoSuchElementException(parameter.node());
        }
        return (T)object.get();
    }

    public <T> Optional<T> getOptional(ContextKey<T> parameter) {
        return Optional.ofNullable(this.params.get(parameter)).map(Supplier::get);
    }

    @Nullable
    public <T> T getOrDefault(ContextKey<T> parameter, @Nullable T defaultValue) {
        return (T)Optional.ofNullable(this.params.get(parameter)).map(Supplier::get).orElse(defaultValue);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<ContextKey<?>, Supplier<Object>> params = new HashMap(8);
        private boolean immutable = false;

        public <T> Builder withParameter(ContextKey<T> parameter, T value) {
            this.params.put(parameter, SimpleSupplier.of(value));
            return this;
        }

        public <T> Builder withParameter(ContextKey<T> parameter, Supplier<T> value) {
            this.params.put(parameter, value);
            return this;
        }

        public <T> Builder withOptionalParameter(ContextKey<T> parameter, @Nullable T value) {
            if (value == null) {
                this.params.remove(parameter);
            } else {
                this.params.put(parameter, SimpleSupplier.of(value));
            }
            return this;
        }

        public <T> T getParameterOrThrow(ContextKey<T> parameter) {
            Supplier<Object> object = this.params.get(parameter);
            if (object == null) {
                throw new NoSuchElementException(parameter.node());
            }
            return (T)object.get();
        }

        public Builder immutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public <T> Optional<T> getOptionalParameter(ContextKey<T> parameter) {
            return Optional.ofNullable(this.params.get(parameter)).map(Supplier::get);
        }

        public ContextHolder build() {
            return new ContextHolder(this.params, this.immutable);
        }
    }

    public static class SimpleSupplier<T>
    implements Supplier<T> {
        private final T object;

        public SimpleSupplier(T object) {
            this.object = object;
        }

        @Override
        public T get() {
            return this.object;
        }

        public static <T> SimpleSupplier<T> of(T object) {
            return new SimpleSupplier<T>(object);
        }
    }
}

