/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.Nullable;

public class GlobalVariableManager
implements Manageable {
    private final Map<String, String> globalVariables = new HashMap<String, String>();
    private final GlobalVariableParser parser = new GlobalVariableParser();

    @Nullable
    public String get(String key) {
        return this.globalVariables.get(key);
    }

    @Override
    public void unload() {
        this.globalVariables.clear();
    }

    public Map<String, String> globalVariables() {
        return Collections.unmodifiableMap(this.globalVariables);
    }

    public ConfigParser parser() {
        return this.parser;
    }

    public class GlobalVariableParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"global-variables", "global-variable"};

        @Override
        public int loadingSequence() {
            return 10;
        }

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public boolean supportsParsingObject() {
            return true;
        }

        @Override
        public void parseObject(Pack pack, Path path, Key id, Object object) throws LocalizedException {
            if (object != null) {
                GlobalVariableManager.this.globalVariables.put(id.value(), object.toString());
            }
        }
    }
}

