/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.block.state.StatePropertyAccessor;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.ExistingBlock;

public class MatchBlockPropertyCondition<CTX extends Context>
implements Condition<CTX> {
    private final List<Pair<String, String>> properties;

    public MatchBlockPropertyCondition(List<Pair<String, String>> properties) {
        this.properties = properties;
    }

    @Override
    public Key type() {
        return CommonConditions.MATCH_BLOCK_PROPERTY;
    }

    @Override
    public boolean test(CTX ctx) {
        ImmutableBlockState customBlockState = null;
        StatePropertyAccessor vanillaStatePropertyAccessor = null;
        Optional<ImmutableBlockState> optionalCustomState = ctx.getOptionalParameter(DirectContextParameters.CUSTOM_BLOCK_STATE);
        if (optionalCustomState.isPresent()) {
            customBlockState = optionalCustomState.get();
        } else {
            Optional<ExistingBlock> optionalExistingBlock = ctx.getOptionalParameter(DirectContextParameters.BLOCK);
            if (optionalExistingBlock.isPresent()) {
                ExistingBlock existingBlock = optionalExistingBlock.get();
                customBlockState = existingBlock.customBlockState();
                if (customBlockState == null) {
                    vanillaStatePropertyAccessor = existingBlock.createStatePropertyAccessor();
                }
            } else {
                return false;
            }
        }
        if (customBlockState != null) {
            CustomBlock block = customBlockState.owner().value();
            for (Pair pair : this.properties) {
                Property<?> propertyIns = block.getProperty((String)pair.left());
                if (propertyIns == null) {
                    return false;
                }
                if (customBlockState.get(propertyIns).toString().toLowerCase(Locale.ENGLISH).equals(pair.right())) continue;
                return false;
            }
        } else {
            for (Pair<String, String> property : this.properties) {
                String string = vanillaStatePropertyAccessor.getPropertyValueAsString(property.left());
                if (string == null) {
                    return false;
                }
                if (string.equals(property.right())) continue;
                return false;
            }
        }
        return true;
    }

    public static class FactoryImpl<CTX extends Context>
    implements ConditionFactory<CTX> {
        @Override
        public Condition<CTX> create(Map<String, Object> arguments) {
            Object propertyObj = ResourceConfigUtils.requireNonNullOrThrow(arguments.get("properties"), "warning.config.condition.match_block_property.missing_properties");
            ArrayList<Pair<String, String>> propertyList = new ArrayList<Pair<String, String>>();
            for (Map.Entry<String, Object> entry : MiscUtils.castToMap(propertyObj, false).entrySet()) {
                propertyList.add(new Pair<String, String>(entry.getKey(), entry.getValue().toString()));
            }
            return new MatchBlockPropertyCondition(propertyList);
        }
    }
}

