/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.event;

import java.util.Map;
import net.momirealms.craftengine.core.plugin.context.Condition;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.condition.AllOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.AnyOfCondition;
import net.momirealms.craftengine.core.plugin.context.condition.CommonConditions;
import net.momirealms.craftengine.core.plugin.context.condition.ConditionFactory;
import net.momirealms.craftengine.core.plugin.context.condition.DistanceCondition;
import net.momirealms.craftengine.core.plugin.context.condition.EnchantmentCondition;
import net.momirealms.craftengine.core.plugin.context.condition.ExpressionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.FallingBlockCondition;
import net.momirealms.craftengine.core.plugin.context.condition.HandCondition;
import net.momirealms.craftengine.core.plugin.context.condition.InvertedCondition;
import net.momirealms.craftengine.core.plugin.context.condition.IsNullCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchBlockCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchBlockPropertyCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchEntityCondition;
import net.momirealms.craftengine.core.plugin.context.condition.MatchItemCondition;
import net.momirealms.craftengine.core.plugin.context.condition.OnCooldownCondition;
import net.momirealms.craftengine.core.plugin.context.condition.PermissionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.RandomCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringContainsCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringEqualsCondition;
import net.momirealms.craftengine.core.plugin.context.condition.StringRegexCondition;
import net.momirealms.craftengine.core.plugin.context.condition.SurvivesExplosionCondition;
import net.momirealms.craftengine.core.plugin.context.condition.TableBonusCondition;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class EventConditions {
    public static void register(Key key, ConditionFactory<PlayerOptionalContext> factory) {
        ((WritableRegistry)BuiltInRegistries.EVENT_CONDITION_FACTORY).register(ResourceKey.create(Registries.EVENT_CONDITION_FACTORY.location(), key), factory);
    }

    public static Condition<PlayerOptionalContext> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.event.condition.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        if (key.value().charAt(0) == '!') {
            ConditionFactory<PlayerOptionalContext> factory = BuiltInRegistries.EVENT_CONDITION_FACTORY.getValue(new Key(key.namespace(), key.value().substring(1)));
            if (factory == null) {
                throw new LocalizedResourceConfigException("warning.config.event.condition.invalid_type", type);
            }
            return new InvertedCondition<PlayerOptionalContext>(factory.create(map));
        }
        ConditionFactory<PlayerOptionalContext> factory = BuiltInRegistries.EVENT_CONDITION_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.event.condition.invalid_type", type);
        }
        return factory.create(map);
    }

    static {
        EventConditions.register(CommonConditions.MATCH_ITEM, new MatchItemCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.MATCH_ENTITY, new MatchEntityCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.MATCH_BLOCK, new MatchBlockCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.MATCH_BLOCK_PROPERTY, new MatchBlockPropertyCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.TABLE_BONUS, new TableBonusCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.SURVIVES_EXPLOSION, new SurvivesExplosionCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.ANY_OF, new AnyOfCondition.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventConditions.register(CommonConditions.ALL_OF, new AllOfCondition.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventConditions.register(CommonConditions.ENCHANTMENT, new EnchantmentCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.INVERTED, new InvertedCondition.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventConditions.register(CommonConditions.FALLING_BLOCK, new FallingBlockCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.RANDOM, new RandomCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.DISTANCE, new DistanceCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.PERMISSION, new PermissionCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.EQUALS, new StringEqualsCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.STRING_REGEX, new StringRegexCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.STRING_EQUALS, new StringEqualsCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.STRING_CONTAINS, new StringContainsCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.EXPRESSION, new ExpressionCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.IS_NULL, new IsNullCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.HAND, new HandCondition.FactoryImpl<PlayerOptionalContext>());
        EventConditions.register(CommonConditions.ON_COOLDOWN, new OnCooldownCondition.FactoryImpl<PlayerOptionalContext>());
    }
}

