/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.event;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventConditions;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.function.ActionBarFunction;
import net.momirealms.craftengine.core.plugin.context.function.BreakBlockFunction;
import net.momirealms.craftengine.core.plugin.context.function.CancelEventFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommandFunction;
import net.momirealms.craftengine.core.plugin.context.function.CommonFunctions;
import net.momirealms.craftengine.core.plugin.context.function.DropLootFunction;
import net.momirealms.craftengine.core.plugin.context.function.Function;
import net.momirealms.craftengine.core.plugin.context.function.FunctionFactory;
import net.momirealms.craftengine.core.plugin.context.function.LevelerExpFunction;
import net.momirealms.craftengine.core.plugin.context.function.MessageFunction;
import net.momirealms.craftengine.core.plugin.context.function.MythicMobsSkillFunction;
import net.momirealms.craftengine.core.plugin.context.function.OpenWindowFunction;
import net.momirealms.craftengine.core.plugin.context.function.ParticleFunction;
import net.momirealms.craftengine.core.plugin.context.function.PlaceBlockFunction;
import net.momirealms.craftengine.core.plugin.context.function.PlaySoundFunction;
import net.momirealms.craftengine.core.plugin.context.function.PotionEffectFunction;
import net.momirealms.craftengine.core.plugin.context.function.RemoveCooldownFunction;
import net.momirealms.craftengine.core.plugin.context.function.RemoveFurnitureFunction;
import net.momirealms.craftengine.core.plugin.context.function.RemovePotionEffectFunction;
import net.momirealms.craftengine.core.plugin.context.function.ReplaceFurnitureFunction;
import net.momirealms.craftengine.core.plugin.context.function.RunFunction;
import net.momirealms.craftengine.core.plugin.context.function.SetCooldownFunction;
import net.momirealms.craftengine.core.plugin.context.function.SetCountFunction;
import net.momirealms.craftengine.core.plugin.context.function.SetFoodFunction;
import net.momirealms.craftengine.core.plugin.context.function.SetSaturationFunction;
import net.momirealms.craftengine.core.plugin.context.function.SetVariableFunction;
import net.momirealms.craftengine.core.plugin.context.function.SpawnFurnitureFunction;
import net.momirealms.craftengine.core.plugin.context.function.SwingHandFunction;
import net.momirealms.craftengine.core.plugin.context.function.TeleportFunction;
import net.momirealms.craftengine.core.plugin.context.function.TitleFunction;
import net.momirealms.craftengine.core.plugin.context.function.ToastFunction;
import net.momirealms.craftengine.core.plugin.context.function.UpdateInteractionFunction;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.registry.Registries;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.ResourceKey;

public class EventFunctions {
    public static void register(Key key, FunctionFactory<PlayerOptionalContext> factory) {
        ((WritableRegistry)BuiltInRegistries.EVENT_FUNCTION_FACTORY).register(ResourceKey.create(Registries.EVENT_FUNCTION_FACTORY.location(), key), factory);
    }

    public static Function<PlayerOptionalContext> fromMap(Map<String, Object> map) {
        String type = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("type"), "warning.config.function.missing_type");
        Key key = Key.withDefaultNamespace(type, "craftengine");
        FunctionFactory<PlayerOptionalContext> factory = BuiltInRegistries.EVENT_FUNCTION_FACTORY.getValue(key);
        if (factory == null) {
            throw new LocalizedResourceConfigException("warning.config.function.invalid_type", type);
        }
        return factory.create(map);
    }

    public static Map<EventTrigger, List<Function<PlayerOptionalContext>>> parseEvents(Object eventsObj) {
        EnumMap<EventTrigger, List<Function<PlayerOptionalContext>>> events;
        block9: {
            List list;
            block8: {
                if (eventsObj == null) {
                    return Map.of();
                }
                events = new EnumMap<EventTrigger, List<Function<PlayerOptionalContext>>>(EventTrigger.class);
                if (!(eventsObj instanceof Map)) break block8;
                Map eventsSection = (Map)eventsObj;
                Map<String, Object> eventsSectionMap = MiscUtils.castToMap(eventsSection, false);
                for (Map.Entry<String, Object> eventEntry : eventsSectionMap.entrySet()) {
                    try {
                        EventTrigger eventTrigger = EventTrigger.byName(eventEntry.getKey());
                        events.put(eventTrigger, ResourceConfigUtils.parseConfigAsList(eventEntry.getValue(), EventFunctions::fromMap));
                    }
                    catch (IllegalArgumentException e) {
                        throw new LocalizedResourceConfigException("warning.config.event.invalid_trigger", eventEntry.getKey());
                    }
                }
                break block9;
            }
            if (!(eventsObj instanceof List)) break block9;
            List eventsList = list = (List)eventsObj;
            for (Map eventSection : eventsList) {
                String on = ResourceConfigUtils.requireNonEmptyStringOrThrow(eventSection.get("on"), "warning.config.event.missing_trigger");
                try {
                    EventTrigger eventTrigger = EventTrigger.byName(on);
                    if (eventSection.containsKey("type")) {
                        Function<PlayerOptionalContext> function = EventFunctions.fromMap(eventSection);
                        events.computeIfAbsent(eventTrigger, k -> new ArrayList(4)).add(function);
                        continue;
                    }
                    if (!eventSection.containsKey("functions")) continue;
                    events.computeIfAbsent(eventTrigger, k -> new ArrayList(4)).add(Objects.requireNonNull(BuiltInRegistries.EVENT_FUNCTION_FACTORY.getValue(CommonFunctions.RUN)).create(eventSection));
                }
                catch (IllegalArgumentException e) {
                    throw new LocalizedResourceConfigException("warning.config.event.invalid_trigger", on);
                }
            }
        }
        return events;
    }

    static {
        EventFunctions.register(CommonFunctions.COMMAND, new CommandFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.MESSAGE, new MessageFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.ACTIONBAR, new ActionBarFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.TITLE, new TitleFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.OPEN_WINDOW, new OpenWindowFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.CANCEL_EVENT, new CancelEventFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.RUN, new RunFunction.FactoryImpl<PlayerOptionalContext>(EventFunctions::fromMap, EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.PLACE_BLOCK, new PlaceBlockFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.BREAK_BLOCK, new BreakBlockFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.UPDATE_INTERACTION_TICK, new UpdateInteractionFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SET_COUNT, new SetCountFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.DROP_LOOT, new DropLootFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SWING_HAND, new SwingHandFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SET_FOOD, new SetFoodFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SET_SATURATION, new SetSaturationFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.PLAY_SOUND, new PlaySoundFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.PARTICLE, new ParticleFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.POTION_EFFECT, new PotionEffectFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.REMOVE_POTION_EFFECT, new RemovePotionEffectFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.LEVELER_EXP, new LevelerExpFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SET_COOLDOWN, new SetCooldownFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.REMOVE_COOLDOWN, new RemoveCooldownFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SPAWN_FURNITURE, new SpawnFurnitureFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.REMOVE_FURNITURE, new RemoveFurnitureFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.REPLACE_FURNITURE, new ReplaceFurnitureFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.MYTHIC_MOBS_SKILL, new MythicMobsSkillFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.TELEPORT, new TeleportFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.SET_VARIABLE, new SetVariableFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
        EventFunctions.register(CommonFunctions.TOAST, new ToastFunction.FactoryImpl<PlayerOptionalContext>(EventConditions::fromMap));
    }
}

