/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.context.number;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.number.NumberProvider;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviderFactory;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;

public class GaussianNumberProvider
implements NumberProvider {
    public static final Factory FACTORY = new Factory();
    private final double min;
    private final double max;
    private final double mean;
    private final double stdDev;
    private final int maxAttempts;

    public GaussianNumberProvider(double min, double max, double mean, double stdDev, int maxAttempts) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.stdDev = stdDev;
        this.maxAttempts = maxAttempts;
        this.validateParameters();
    }

    private void validateParameters() {
        if (this.min >= this.max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        if (this.stdDev <= 0.0) {
            throw new IllegalArgumentException("std-dev must be greater than 0");
        }
        if (this.maxAttempts <= 0) {
            throw new IllegalArgumentException("max-attempts must be greater than 0");
        }
    }

    @Override
    public float getFloat(Context context) {
        return (float)this.getDouble(context);
    }

    @Override
    public double getDouble(Context context) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int attempts = 0; attempts < this.maxAttempts; ++attempts) {
            double value = random.nextGaussian() * this.stdDev + this.mean;
            if (!(value >= this.min) || !(value <= this.max)) continue;
            return value;
        }
        return MCUtils.clamp(this.mean, this.min, this.max);
    }

    @Override
    public Key type() {
        return NumberProviders.GAUSSIAN;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public int maxAttempts() {
        return this.maxAttempts;
    }

    public double mean() {
        return this.mean;
    }

    public double stdDev() {
        return this.stdDev;
    }

    public String toString() {
        return String.format("GaussianNumberProvider{min=%.2f, max=%.2f, mean=%.2f, stdDev=%.2f, maxAttempts=%d}", this.min, this.max, this.mean, this.stdDev, this.maxAttempts);
    }

    public static class Factory
    implements NumberProviderFactory {
        @Override
        public NumberProvider create(Map<String, Object> arguments) {
            double min = ResourceConfigUtils.getAsDouble(ResourceConfigUtils.requireNonNullOrThrow(arguments.get("min"), "warning.config.number.gaussian.missing_min"), "min");
            double max = ResourceConfigUtils.getAsDouble(ResourceConfigUtils.requireNonNullOrThrow(arguments.get("max"), "warning.config.number.gaussian.missing_max"), "max");
            double mean = ResourceConfigUtils.getAsDouble(arguments.getOrDefault("mean", (min + max) / 2.0), "mean");
            double stdDev = ResourceConfigUtils.getAsDouble(arguments.getOrDefault("std-dev", (max - min) / 6.0), "std-dev");
            int maxAttempts = ResourceConfigUtils.getAsInt(arguments.getOrDefault("max-attempts", 128), "max-attempts");
            return new GaussianNumberProvider(min, max, mean, stdDev, maxAttempts);
        }
    }
}

