/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.gui.category;

import java.util.ArrayList;
import java.util.List;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.NotNull;

public class Category
implements Comparable<Category> {
    private final Key id;
    private final String displayName;
    private final List<String> displayLore;
    private final Key icon;
    private final List<String> members;
    private final int priority;
    private final boolean hidden;

    public Category(Key id, String displayName, List<String> displayLore, Key icon, List<String> members, int priority, boolean hidden) {
        this.id = id;
        this.displayName = displayName;
        this.members = new ArrayList<String>(members);
        this.icon = icon;
        this.priority = priority;
        this.displayLore = new ArrayList<String>(displayLore);
        this.hidden = hidden;
    }

    public void addMember(String member) {
        this.members.add(member);
    }

    public Key id() {
        return this.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public Key icon() {
        return this.icon;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public List<String> displayLore() {
        return this.displayLore;
    }

    public List<String> members() {
        return this.members;
    }

    public void merge(Category other) {
        for (String member : other.members) {
            this.addMember(member);
        }
    }

    @Override
    public int compareTo(@NotNull Category o) {
        if (this.priority != o.priority) {
            return this.priority - o.priority;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(this.id.toString(), o.id.toString());
    }
}

