/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.gui.category;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.recipe.CustomBrewingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCookingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCraftingTableRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.gui.BasicGui;
import net.momirealms.craftengine.core.plugin.gui.Gui;
import net.momirealms.craftengine.core.plugin.gui.GuiElement;
import net.momirealms.craftengine.core.plugin.gui.GuiElementMissingException;
import net.momirealms.craftengine.core.plugin.gui.GuiLayout;
import net.momirealms.craftengine.core.plugin.gui.GuiParameters;
import net.momirealms.craftengine.core.plugin.gui.Ingredient;
import net.momirealms.craftengine.core.plugin.gui.ItemWithAction;
import net.momirealms.craftengine.core.plugin.gui.PagedGui;
import net.momirealms.craftengine.core.plugin.gui.category.Category;
import net.momirealms.craftengine.core.plugin.gui.category.ItemBrowserManager;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextDecoration;

public class ItemBrowserManagerImpl
implements ItemBrowserManager {
    private static final String SHIFT_LEFT = "SHIFT_LEFT";
    private static final String SHIFT_RIGHT = "SHIFT_RIGHT";
    private static final Set<String> MOVE_TO_OTHER_INV = Set.of("SHIFT_LEFT", "SHIFT_RIGHT");
    private static final Set<String> LEFT_CLICK = Set.of("LEFT", "SHIFT_LEFT");
    private static final Set<String> RIGHT_CLICK = Set.of("RIGHT", "SHIFT_RIGHT");
    private static final Set<String> MIDDLE_CLICK = Set.of("MIDDLE");
    private static final Set<String> DOUBLE_CLICK = Set.of("DOUBLE_CLICK");
    private final CraftEngine plugin;
    private final Map<Key, Category> byId;
    private final TreeSet<Category> categoryOnMainPage;
    private final Map<Key, List<Key>> externalMembers;
    private final CategoryParser categoryParser;

    public ItemBrowserManagerImpl(CraftEngine plugin) {
        this.plugin = plugin;
        this.byId = new HashMap<Key, Category>();
        this.externalMembers = new HashMap<Key, List<Key>>();
        this.categoryOnMainPage = new TreeSet();
        this.categoryParser = new CategoryParser();
    }

    @Override
    public void unload() {
        this.byId.clear();
        this.categoryOnMainPage.clear();
        this.externalMembers.clear();
    }

    @Override
    public void delayedLoad() {
        for (Map.Entry<Key, List<Key>> entry : this.externalMembers.entrySet()) {
            Key item = entry.getKey();
            for (Key categoryId : entry.getValue()) {
                Optional.ofNullable(this.byId.get(categoryId)).ifPresent(category -> category.addMember(item.toString()));
            }
        }
        for (Category category2 : this.byId.values()) {
            if (category2.hidden()) continue;
            this.categoryOnMainPage.add(category2);
        }
        ItemBrowserManager.Constants.load();
    }

    @Override
    public ConfigParser parser() {
        return this.categoryParser;
    }

    @Override
    public void addExternalCategoryMember(Key item, List<Key> category) {
        List categories = this.externalMembers.computeIfAbsent(item, k -> new ArrayList());
        categories.addAll(category);
    }

    @Override
    public void open(Player player) {
        this.openItemBrowser(player);
    }

    @Override
    public TreeSet<Category> categories() {
        return this.categoryOnMainPage;
    }

    @Override
    public Optional<Category> byId(Key key) {
        return Optional.ofNullable(this.byId.get(key));
    }

    public void openItemBrowser(Player player) {
        GuiLayout layout = new GuiLayout("AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", " <     > ").addIngredient('A', Ingredient.paged()).addIngredient('>', GuiElement.paged(element -> {
            Key next = element.gui().hasNextPage() ? ItemBrowserManager.Constants.BROWSER_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.BROWSER_NEXT_PAGE_BLOCK;
            return this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(element.gui().currentPage())).withParameter(GuiParameters.MAX_PAGE, String.valueOf(element.gui().maxPages()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next)));
        }, true)).addIngredient('<', GuiElement.paged(element -> {
            Key previous = element.gui().hasPreviousPage() ? ItemBrowserManager.Constants.BROWSER_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.BROWSER_PREVIOUS_PAGE_BLOCK;
            return this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(element.gui().currentPage())).withParameter(GuiParameters.MAX_PAGE, String.valueOf(element.gui().maxPages()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous)));
        }, false));
        List<ItemWithAction> iconList = this.categoryOnMainPage.stream().map(it -> {
            Item item = this.plugin.itemManager().createWrappedItem(it.icon(), player);
            if (ItemUtils.isEmpty(item)) {
                this.plugin.logger().warn("Can't not find item " + String.valueOf(it.icon()) + " for category icon");
                return null;
            }
            item.customNameJson(AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(it.displayName(), ItemBuildContext.EMPTY_RESOLVERS)));
            item.loreJson(it.displayLore().stream().map(lore -> AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(lore, ItemBuildContext.EMPTY_RESOLVERS))).toList());
            return new ItemWithAction(item, (element, click) -> {
                click.cancel();
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                this.openCategoryPage(click.clicker(), it.id(), element.gui(), true);
            });
        }).filter(Objects::nonNull).toList();
        PagedGui.builder().addIngredients(iconList).layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.BROWSER_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public void openCategoryPage(Player player, Key categoryId, Gui parentGui, boolean canOpenNoRecipePage) {
        GuiLayout layout = new GuiLayout("AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", "AAAAAAAAA", " <  =  > ").addIngredient('A', Ingredient.paged()).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.CATEGORY_BACK : ItemBrowserManager.Constants.CATEGORY_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.CATEGORY_BACK : ItemBrowserManager.Constants.CATEGORY_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.paged(element -> {
            Key next = element.gui().hasNextPage() ? ItemBrowserManager.Constants.CATEGORY_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.CATEGORY_NEXT_PAGE_BLOCK;
            return this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(element.gui().currentPage())).withParameter(GuiParameters.MAX_PAGE, String.valueOf(element.gui().maxPages()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next)));
        }, true)).addIngredient('<', GuiElement.paged(element -> {
            Key previous = element.gui().hasPreviousPage() ? ItemBrowserManager.Constants.CATEGORY_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.CATEGORY_PREVIOUS_PAGE_BLOCK;
            return this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(element.gui().currentPage())).withParameter(GuiParameters.MAX_PAGE, String.valueOf(element.gui().maxPages()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous)));
        }, false));
        Optional<Category> optionalCategory = this.byId(categoryId);
        if (optionalCategory.isEmpty()) {
            this.plugin.logger().warn("Can't find category " + String.valueOf(categoryId));
            return;
        }
        Category category = optionalCategory.get();
        List<ItemWithAction> itemList = category.members().stream().map(it -> {
            boolean canGoFurther;
            if (it.charAt(0) == '#') {
                Item item;
                String subCategoryId = it.substring(1);
                Category subCategory = this.byId.get(Key.of(subCategoryId));
                if (subCategory == null) {
                    item = Objects.requireNonNull(this.plugin.itemManager().createWrappedItem(ItemKeys.BARRIER, player));
                    item.customNameJson(AdventureHelper.componentToJson(((TextComponent)Component.text((String)subCategoryId).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false)));
                } else {
                    item = this.plugin.itemManager().createWrappedItem(subCategory.icon(), player);
                    if (ItemUtils.isEmpty(item)) {
                        if (!subCategory.icon().equals(ItemKeys.AIR)) {
                            item = Objects.requireNonNull(this.plugin.itemManager().createWrappedItem(ItemKeys.BARRIER, player));
                            item.customNameJson(AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(subCategory.displayName(), ItemBuildContext.EMPTY_RESOLVERS)));
                            item.loreJson(subCategory.displayLore().stream().map(lore -> AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(lore, ItemBuildContext.EMPTY_RESOLVERS))).toList());
                        }
                    } else {
                        item.customNameJson(AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(subCategory.displayName(), ItemBuildContext.EMPTY_RESOLVERS)));
                        item.loreJson(subCategory.displayLore().stream().map(lore -> AdventureHelper.componentToJson(AdventureHelper.miniMessage().deserialize(lore, ItemBuildContext.EMPTY_RESOLVERS))).toList());
                    }
                }
                return new ItemWithAction(item, (element, click) -> {
                    click.cancel();
                    player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                    if (subCategory == null) {
                        return;
                    }
                    this.openCategoryPage(click.clicker(), subCategory.id(), element.gui(), canOpenNoRecipePage);
                });
            }
            Key itemId = Key.of(it);
            Item item = this.plugin.itemManager().createWrappedItem(itemId, player);
            if (ItemUtils.isEmpty(item)) {
                if (!itemId.equals(ItemKeys.AIR)) {
                    item = this.plugin.itemManager().createWrappedItem(ItemKeys.BARRIER, player);
                    item.customNameJson(AdventureHelper.componentToJson(((TextComponent)Component.text((String)it).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)).color((TextColor)NamedTextColor.RED)));
                }
                canGoFurther = false;
            } else {
                canGoFurther = true;
            }
            return new ItemWithAction(item, (e, c) -> {
                c.cancel();
                Item<?> eItem = e.item();
                if (!canGoFurther) {
                    return;
                }
                if (player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item")) {
                    if (MIDDLE_CLICK.contains(c.type()) && c.itemOnCursor() == null) {
                        Item newItem = this.plugin.itemManager().createWrappedItem(eItem.id(), player);
                        newItem.count(newItem.maxStackSize());
                        c.setItemOnCursor(newItem);
                        return;
                    }
                    if (SHIFT_LEFT.equals(c.type())) {
                        player.giveItem(this.plugin.itemManager().createWrappedItem(eItem.id(), player));
                        return;
                    }
                    if (SHIFT_RIGHT.equals(c.type())) {
                        Item newItem = this.plugin.itemManager().createWrappedItem(eItem.id(), player);
                        newItem.count(newItem.maxStackSize());
                        player.giveItem(newItem);
                        return;
                    }
                }
                if (LEFT_CLICK.contains(c.type())) {
                    List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(itemId);
                    player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                    if (!inRecipes.isEmpty()) {
                        this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, 0, canOpenNoRecipePage);
                    } else if (canOpenNoRecipePage) {
                        this.openNoRecipePage(player, itemId, e.gui(), 0);
                    }
                } else if (RIGHT_CLICK.contains(c.type())) {
                    List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(itemId);
                    player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                    if (!inRecipes.isEmpty()) {
                        this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, 0, canOpenNoRecipePage);
                    }
                }
            });
        }).toList();
        PagedGui.builder().addIngredients(itemList).layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.CATEGORY_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    @Override
    public void openNoRecipePage(Player player, Key result, Gui parentGui, int depth) {
        GuiLayout layout = new GuiLayout("         ", "         ", "    X    ", "    ^    ", "         ", "    =    ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, true);
                }
            }
        })).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(result, player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        }));
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.RECIPE_NONE_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    @Override
    public void openRecipePage(Player player, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        if (index >= recipes.size()) {
            return;
        }
        if (depth > 16) {
            return;
        }
        Recipe<Object> recipe = recipes.get(index);
        Key recipeType = recipe.serializerType();
        if (recipeType == RecipeSerializers.SHAPELESS || recipeType == RecipeSerializers.SHAPED) {
            this.openCraftingRecipePage(player, (CustomCraftingTableRecipe)recipe, parentGui, recipes, index, depth, canOpenNoRecipePage);
            return;
        }
        if (recipeType == RecipeSerializers.BLASTING || recipeType == RecipeSerializers.CAMPFIRE_COOKING || recipeType == RecipeSerializers.SMOKING || recipeType == RecipeSerializers.SMELTING) {
            this.openCookingRecipePage(player, (CustomCookingRecipe)recipe, parentGui, recipes, index, depth, canOpenNoRecipePage);
            return;
        }
        if (recipeType == RecipeSerializers.STONECUTTING) {
            this.openStoneCuttingRecipePage(player, (CustomStoneCuttingRecipe)recipe, parentGui, recipes, index, depth, canOpenNoRecipePage);
            return;
        }
        if (recipeType == RecipeSerializers.SMITHING_TRANSFORM) {
            this.openSmithingTransformRecipePage(player, (CustomSmithingTransformRecipe)recipe, parentGui, recipes, index, depth, canOpenNoRecipePage);
            return;
        }
        if (recipeType == RecipeSerializers.BREWING) {
            this.openBrewingRecipePage(player, (CustomBrewingRecipe)recipe, parentGui, recipes, index, depth, canOpenNoRecipePage);
            return;
        }
    }

    public void openBrewingRecipePage(Player player, CustomBrewingRecipe<Object> recipe, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        Key previous = index > 0 ? ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_BLOCK;
        Key next = index + 1 < recipes.size() ? ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_BLOCK;
        Key result = recipe.result().item().id();
        ArrayList ingredients = new ArrayList();
        net.momirealms.craftengine.core.item.recipe.Ingredient<Object> ingredient = recipe.ingredient();
        for (UniqueKey in : ingredient.items()) {
            ingredients.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
        }
        ArrayList containers = new ArrayList();
        net.momirealms.craftengine.core.item.recipe.Ingredient<Object> container = recipe.container();
        for (UniqueKey in : container.items()) {
            containers.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
        }
        GuiLayout layout = new GuiLayout("         ", "   A     ", "         ", "   B X   ", "     ^   ", " <  =  > ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player).count(recipe.result().count()), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, result, e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(result, player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.constant(this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next))), (e, c) -> {
            c.cancel();
            if (index + 1 < recipes.size()) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index + 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('<', GuiElement.constant(this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous))), (e, c) -> {
            c.cancel();
            if (index > 0) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index - 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('A', GuiElement.recipeIngredient(ingredients, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('B', GuiElement.recipeIngredient(containers, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        }));
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.RECIPE_BREWING_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public void openSmithingTransformRecipePage(Player player, CustomSmithingTransformRecipe<Object> recipe, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        Key previous = index > 0 ? ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_BLOCK;
        Key next = index + 1 < recipes.size() ? ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_BLOCK;
        Key result = recipe.result().item().id();
        GuiLayout layout = new GuiLayout("         ", "         ", " ABC  X  ", "      ^  ", "         ", " <  =  > ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player).count(recipe.result().count()), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, result, e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(result, player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.constant(this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next))), (e, c) -> {
            c.cancel();
            if (index + 1 < recipes.size()) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index + 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('<', GuiElement.constant(this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous))), (e, c) -> {
            c.cancel();
            if (index > 0) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index - 1, depth, canOpenNoRecipePage);
            }
        }));
        ArrayList templates = new ArrayList();
        Optional.ofNullable(recipe.template()).ifPresent(it -> {
            for (UniqueKey in : it.items()) {
                templates.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
            }
        });
        layout.addIngredient('A', templates.isEmpty() ? GuiElement.EMPTY : GuiElement.recipeIngredient(templates, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        }));
        ArrayList bases = new ArrayList();
        Optional.ofNullable(recipe.base()).ifPresent(it -> {
            for (UniqueKey in : it.items()) {
                bases.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
            }
        });
        layout.addIngredient('B', bases.isEmpty() ? GuiElement.EMPTY : GuiElement.recipeIngredient(bases, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        }));
        ArrayList additions = new ArrayList();
        Optional.ofNullable(recipe.addition()).ifPresent(it -> {
            for (UniqueKey in : it.items()) {
                additions.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
            }
        });
        layout.addIngredient('C', additions.isEmpty() ? GuiElement.EMPTY : GuiElement.recipeIngredient(additions, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        }));
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.RECIPE_SMITHING_TRANSFORM_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public void openStoneCuttingRecipePage(Player player, CustomStoneCuttingRecipe<Object> recipe, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        Key previous = index > 0 ? ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_BLOCK;
        Key next = index + 1 < recipes.size() ? ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_BLOCK;
        Key result = recipe.result().item().id();
        ArrayList ingredients = new ArrayList();
        net.momirealms.craftengine.core.item.recipe.Ingredient<Object> ingredient = recipe.ingredient();
        for (UniqueKey in : ingredient.items()) {
            ingredients.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
        }
        GuiLayout layout = new GuiLayout("         ", "         ", "  A   X  ", "      ^  ", "         ", " <  =  > ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player).count(recipe.result().count()), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, result, e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(result, player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('A', GuiElement.recipeIngredient(ingredients, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.constant(this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next))), (e, c) -> {
            c.cancel();
            if (index + 1 < recipes.size()) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index + 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('<', GuiElement.constant(this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous))), (e, c) -> {
            c.cancel();
            if (index > 0) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index - 1, depth, canOpenNoRecipePage);
            }
        }));
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.RECIPE_STONECUTTING_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public void openCookingRecipePage(Player player, CustomCookingRecipe<Object> recipe, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        Key previous = index > 0 ? ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_BLOCK;
        Key next = index + 1 < recipes.size() ? ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_BLOCK;
        Key result = recipe.result().item().id();
        ArrayList ingredients = new ArrayList();
        net.momirealms.craftengine.core.item.recipe.Ingredient<Object> ingredient = recipe.ingredient();
        for (UniqueKey in : ingredient.items()) {
            ingredients.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
        }
        GuiLayout layout = new GuiLayout("         ", "         ", "  A   X  ", "  ?   ^  ", "         ", " <  =  > ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player).count(recipe.result().count()), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, result, e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('?', GuiElement.constant(this.plugin.itemManager().getCustomItem(ItemBrowserManager.Constants.RECIPE_COOKING_INFO).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.COOKING_TIME, String.valueOf(recipe.cookingTime())).withParameter(GuiParameters.COOKING_EXPERIENCE, String.valueOf(recipe.experience()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(ItemBrowserManager.Constants.RECIPE_COOKING_INFO))), (e, c) -> c.cancel())).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(result, player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(result, player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('A', GuiElement.recipeIngredient(ingredients, (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.constant(this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next))), (e, c) -> {
            c.cancel();
            if (index + 1 < recipes.size()) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index + 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('<', GuiElement.constant(this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous))), (e, c) -> {
            c.cancel();
            if (index > 0) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index - 1, depth, canOpenNoRecipePage);
            }
        }));
        String title = recipe.serializerType() == RecipeSerializers.SMELTING ? ItemBrowserManager.Constants.RECIPE_SMELTING_TITLE : (recipe.serializerType() == RecipeSerializers.BLASTING ? ItemBrowserManager.Constants.RECIPE_BLASTING_TITLE : (recipe.serializerType() == RecipeSerializers.CAMPFIRE_COOKING ? ItemBrowserManager.Constants.RECIPE_CAMPFIRE_TITLE : ItemBrowserManager.Constants.RECIPE_SMOKING_TITLE));
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(title, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public void openCraftingRecipePage(Player player, CustomCraftingTableRecipe<Object> recipe, Gui parentGui, List<Recipe<Object>> recipes, int index, int depth, boolean canOpenNoRecipePage) {
        Key previous = index > 0 ? ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_PREVIOUS_PAGE_BLOCK;
        Key next = index + 1 < recipes.size() ? ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_AVAILABLE : ItemBrowserManager.Constants.RECIPE_NEXT_PAGE_BLOCK;
        Key result = recipe.result().item().id();
        GuiLayout layout = new GuiLayout("         ", " ABC     ", " DEF   X ", " GHI   ^ ", "         ", " <  =  > ").addIngredient('X', GuiElement.constant(this.plugin.itemManager().createWrappedItem(result, player).count(recipe.result().count()), (e, c) -> {
            c.cancel();
            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                Item item = this.plugin.itemManager().createWrappedItem(recipe.result().item().id(), player);
                item.count(item.maxStackSize());
                c.setItemOnCursor(item);
                return;
            }
            if (LEFT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                } else if (canOpenNoRecipePage) {
                    this.openNoRecipePage(player, result, e.gui(), 0);
                }
            } else if (RIGHT_CLICK.contains(c.type())) {
                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(result);
                if (inRecipes == recipes) {
                    return;
                }
                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                if (!inRecipes.isEmpty()) {
                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                }
            }
        })).addIngredient('^', player.hasPermission("craftengine.browser.get_item") ? GuiElement.constant(this.plugin.itemManager().createWrappedItem(ItemBrowserManager.Constants.RECIPE_GET_ITEM, player), (e, c) -> {
            c.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_PICK_ITEM);
            if (LEFT_CLICK.contains(c.type())) {
                player.giveItem(this.plugin.itemManager().createWrappedItem(recipe.result().item().id(), player));
            } else if (RIGHT_CLICK.contains(c.type())) {
                Item item = this.plugin.itemManager().createWrappedItem(recipe.result().item().id(), player);
                player.giveItem(item.count(item.maxStackSize()));
            }
        }) : GuiElement.EMPTY).addIngredient('=', GuiElement.constant(this.plugin.itemManager().getCustomItem(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT).map(it -> it.buildItem(ItemBuildContext.of(player))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(parentGui != null ? ItemBrowserManager.Constants.RECIPE_BACK : ItemBrowserManager.Constants.RECIPE_EXIT))), (element, click) -> {
            click.cancel();
            player.playSound(ItemBrowserManager.Constants.SOUND_RETURN_PAGE, 0.25f, 1.0f);
            if (parentGui != null) {
                parentGui.open(player);
            } else {
                player.closeInventory();
            }
        })).addIngredient('>', GuiElement.constant(this.plugin.itemManager().getCustomItem(next).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(next))), (e, c) -> {
            c.cancel();
            if (index + 1 < recipes.size()) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index + 1, depth, canOpenNoRecipePage);
            }
        })).addIngredient('<', GuiElement.constant(this.plugin.itemManager().getCustomItem(previous).map(it -> it.buildItem(ItemBuildContext.of(player, ContextHolder.builder().withParameter(GuiParameters.CURRENT_PAGE, String.valueOf(index + 1)).withParameter(GuiParameters.MAX_PAGE, String.valueOf(recipes.size()))))).orElseThrow(() -> new GuiElementMissingException("Can't find gui element " + String.valueOf(previous))), (e, c) -> {
            c.cancel();
            if (index > 0) {
                player.playSound(ItemBrowserManager.Constants.SOUND_CHANGE_PAGE, 0.25f, 1.0f);
                this.openRecipePage(player, parentGui, recipes, index - 1, depth, canOpenNoRecipePage);
            }
        }));
        int start = 65;
        if (recipe.serializerType() == RecipeSerializers.SHAPED) {
            String[] pattern = ((CustomShapedRecipe)recipe).pattern().pattern();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    char currentChar = (char)(start + x + y * 3);
                    if (x < pattern[0].length() && y < pattern.length) {
                        char ingredientChar = pattern[y].charAt(x);
                        net.momirealms.craftengine.core.item.recipe.Ingredient ingredient = ((CustomShapedRecipe)recipe).pattern().ingredients().get(Character.valueOf(ingredientChar));
                        if (ingredient == null) {
                            layout.addIngredient(currentChar, Ingredient.EMPTY);
                            continue;
                        }
                        ArrayList ingredients = new ArrayList();
                        for (UniqueKey in : ingredient.items()) {
                            ingredients.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
                        }
                        layout.addIngredient(currentChar, GuiElement.recipeIngredient(ingredients, (e, c) -> {
                            c.cancel();
                            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                                item.count(item.maxStackSize());
                                c.setItemOnCursor(item);
                                return;
                            }
                            if (LEFT_CLICK.contains(c.type())) {
                                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                                if (inRecipes == recipes) {
                                    return;
                                }
                                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                                if (!inRecipes.isEmpty()) {
                                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                                } else if (canOpenNoRecipePage) {
                                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                                }
                            } else if (RIGHT_CLICK.contains(c.type())) {
                                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                                if (inRecipes == recipes) {
                                    return;
                                }
                                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                                if (!inRecipes.isEmpty()) {
                                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                                }
                            }
                        }));
                        continue;
                    }
                    layout.addIngredient(currentChar, Ingredient.EMPTY);
                }
            }
        } else {
            List ingredients = recipe.ingredientsInUse();
            int i = 0;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    char currentChar = (char)(start + x + y * 3);
                    if (i < ingredients.size()) {
                        ArrayList ingredientItems = new ArrayList();
                        for (UniqueKey in : ingredients.get(i).items()) {
                            ingredientItems.add(this.plugin.itemManager().createWrappedItem(in.key(), player));
                        }
                        layout.addIngredient(currentChar, GuiElement.recipeIngredient(ingredientItems, (e, c) -> {
                            c.cancel();
                            if (MIDDLE_CLICK.contains(c.type()) && player.isCreativeMode() && player.hasPermission("craftengine.browser.get_item") && c.itemOnCursor() == null) {
                                Item item = this.plugin.itemManager().createWrappedItem(e.item().id(), player);
                                item.count(item.maxStackSize());
                                c.setItemOnCursor(item);
                                return;
                            }
                            if (LEFT_CLICK.contains(c.type())) {
                                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByResult(e.item().id());
                                if (inRecipes == recipes) {
                                    return;
                                }
                                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                                if (!inRecipes.isEmpty()) {
                                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                                } else if (canOpenNoRecipePage) {
                                    this.openNoRecipePage(player, e.item().id(), e.gui(), 0);
                                }
                            } else if (RIGHT_CLICK.contains(c.type())) {
                                List<Recipe<Object>> inRecipes = this.plugin.recipeManager().recipeByIngredient(e.item().id());
                                if (inRecipes == recipes) {
                                    return;
                                }
                                player.playSound(ItemBrowserManager.Constants.SOUND_CLICK_BUTTON);
                                if (!inRecipes.isEmpty()) {
                                    this.openRecipePage(c.clicker(), e.gui(), inRecipes, 0, depth + 1, canOpenNoRecipePage);
                                }
                            }
                        }));
                    } else {
                        layout.addIngredient(currentChar, Ingredient.EMPTY);
                    }
                    ++i;
                }
            }
        }
        BasicGui.builder().layout(layout).inventoryClickConsumer(c -> {
            if (MOVE_TO_OTHER_INV.contains(c.type()) || DOUBLE_CLICK.contains(c.type())) {
                c.cancel();
            }
        }).build().title(AdventureHelper.miniMessage().deserialize(ItemBrowserManager.Constants.RECIPE_CRAFTING_TITLE, PlayerOptionalContext.of(player).tagResolvers())).refresh().open(player);
    }

    public class CategoryParser
    implements ConfigParser {
        public static final String[] CONFIG_SECTION_NAME = new String[]{"categories", "category"};

        @Override
        public String[] sectionId() {
            return CONFIG_SECTION_NAME;
        }

        @Override
        public int loadingSequence() {
            return 100;
        }

        @Override
        public void parseSection(Pack pack, Path path, Key id, Map<String, Object> section) {
            String name = section.getOrDefault("name", id).toString();
            List<String> members = MiscUtils.getAsStringList(section.getOrDefault("list", List.of()));
            Key icon = Key.of(section.getOrDefault("icon", ItemKeys.STONE).toString());
            int priority = ResourceConfigUtils.getAsInt(section.getOrDefault("priority", 0), "priority");
            Category category = new Category(id, name, MiscUtils.getAsStringList(section.getOrDefault("lore", List.of())), icon, new ArrayList<String>(members), priority, ResourceConfigUtils.getAsBoolean(section.getOrDefault("hidden", false), "hidden"));
            if (ItemBrowserManagerImpl.this.byId.containsKey(id)) {
                ItemBrowserManagerImpl.this.byId.get(id).merge(category);
            } else {
                ItemBrowserManagerImpl.this.byId.put(id, category);
            }
        }
    }
}

