/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.locale;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.momirealms.craftengine.core.plugin.locale.MiniMessageTranslationRegistry;
import net.momirealms.craftengine.core.plugin.text.minimessage.ImageTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.IndexedArgumentTag;
import net.momirealms.craftengine.core.plugin.text.minimessage.ShiftTag;
import net.momirealms.craftengine.libraries.adventure.internal.Internals;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TranslatableComponent;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import net.momirealms.craftengine.libraries.adventure.util.TriState;
import net.momirealms.craftengine.libraries.examination.Examinable;
import net.momirealms.craftengine.libraries.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniMessageTranslationRegistryImpl
implements Examinable,
MiniMessageTranslationRegistry {
    private final Key name;
    private final Map<String, Translation> translations = new ConcurrentHashMap<String, Translation>();
    private Locale defaultLocale = Locale.US;
    private final MiniMessage miniMessage;

    MiniMessageTranslationRegistryImpl(Key name, MiniMessage miniMessage) {
        this.name = name;
        this.miniMessage = miniMessage;
    }

    @Override
    public void register(@NotNull String key, @NotNull Locale locale, @NotNull String format) {
        this.translations.computeIfAbsent(key, x$0 -> new Translation((String)x$0)).register(locale, format);
    }

    @Override
    public void unregister(@NotNull String key) {
        this.translations.remove(key);
    }

    @Override
    public boolean contains(@NotNull String key) {
        return this.translations.containsKey(key);
    }

    @NotNull
    public Key name() {
        return this.name;
    }

    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        return null;
    }

    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        Translation translation = this.translations.get(component.key());
        if (translation == null) {
            return null;
        }
        String miniMessageString = translation.translate(locale);
        if (miniMessageString == null) {
            return null;
        }
        if (miniMessageString.isEmpty()) {
            return Component.empty();
        }
        Component resultingComponent = component.arguments().isEmpty() ? this.miniMessage.deserialize(miniMessageString, new TagResolver[]{ShiftTag.INSTANCE, ImageTag.INSTANCE}) : this.miniMessage.deserialize(miniMessageString, new TagResolver[]{new IndexedArgumentTag(component.arguments()), ShiftTag.INSTANCE, ImageTag.INSTANCE});
        if (component.children().isEmpty()) {
            return resultingComponent;
        }
        return resultingComponent.children(component.children());
    }

    @Override
    public String miniMessageTranslation(@NotNull String key, @NotNull Locale locale) {
        Translation translation = this.translations.get(key);
        if (translation == null) {
            return null;
        }
        return translation.translate(locale);
    }

    @NotNull
    public TriState hasAnyTranslations() {
        if (!this.translations.isEmpty()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    public void defaultLocale(@NotNull Locale defaultLocale) {
        this.defaultLocale = Objects.requireNonNull(defaultLocale, "defaultLocale");
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"translations", this.translations));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MiniMessageTranslationRegistryImpl)) {
            return false;
        }
        MiniMessageTranslationRegistryImpl that = (MiniMessageTranslationRegistryImpl)other;
        return this.name.equals((Object)that.name) && this.translations.equals(that.translations) && this.defaultLocale.equals(that.defaultLocale);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.translations, this.defaultLocale);
    }

    public String toString() {
        return Internals.toString((Examinable)this);
    }

    final class Translation
    implements Examinable {
        private final String key;
        private final Map<Locale, String> formats;

        Translation(String key) {
            this.key = Objects.requireNonNull(key, "translation key");
            this.formats = new ConcurrentHashMap<Locale, String>();
        }

        void register(@NotNull Locale locale, @NotNull String format) {
            if (this.formats.putIfAbsent(Objects.requireNonNull(locale, "locale"), Objects.requireNonNull(format, "message format")) != null) {
                throw new IllegalArgumentException(String.format("Translation already exists: %s for %s", this.key, locale));
            }
        }

        @Nullable
        String translate(@NotNull Locale locale) {
            String format = this.formats.get(Objects.requireNonNull(locale, "locale"));
            if (format == null && (format = this.formats.get(Locale.of(locale.getLanguage()))) == null) {
                format = this.formats.get(MiniMessageTranslationRegistryImpl.this.defaultLocale);
            }
            return format;
        }

        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of((String)"key", (String)this.key), ExaminableProperty.of((String)"formats", this.formats));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Translation)) {
                return false;
            }
            Translation that = (Translation)other;
            return this.key.equals(that.key) && this.formats.equals(that.formats);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.formats);
        }

        public String toString() {
            return Internals.toString((Examinable)this);
        }
    }
}

