/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.logger;

import java.util.function.Supplier;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;

public enum Debugger {
    COMMON(Config::debugCommon),
    PACKET(Config::debugPacket),
    FURNITURE(Config::debugFurniture),
    RESOURCE_PACK(Config::debugResourcePack),
    ITEM(Config::debugItem),
    BLOCK_ENTITY(Config::debugBlockEntity);

    private final Supplier<Boolean> condition;

    private Debugger(Supplier<Boolean> condition) {
        this.condition = condition;
    }

    public void debug(Supplier<String> message) {
        if (this.condition.get().booleanValue()) {
            CraftEngine.instance().logger().info("[DEBUG] " + message.get());
        }
    }

    public void warn(Supplier<String> message, Throwable e) {
        if (this.condition.get().booleanValue()) {
            if (e != null) {
                CraftEngine.instance().logger().warn("[DEBUG] " + message.get(), e);
            } else {
                CraftEngine.instance().logger().warn("[DEBUG] " + message.get());
            }
        }
    }
}

