/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.network.codec;

import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.network.codec.NetworkDecoder;
import net.momirealms.craftengine.core.plugin.network.codec.NetworkEncoder;
import net.momirealms.craftengine.core.plugin.network.codec.NetworkMemberEncoder;

public interface NetworkCodec<B, T>
extends NetworkEncoder<B, T>,
NetworkDecoder<B, T> {
    default public <V> NetworkCodec<B, V> map(final Function<? super T, ? extends V> factory, final Function<? super V, ? extends T> getter) {
        return new NetworkCodec<B, V>(){

            @Override
            public V decode(B in) {
                return factory.apply(NetworkCodec.this.decode(in));
            }

            @Override
            public void encode(B out, V value) {
                NetworkCodec.this.encode(out, getter.apply(value));
            }
        };
    }

    public static <B, V> NetworkCodec<B, V> ofMember(final NetworkMemberEncoder<B, V> networkMemberEncoder, final NetworkDecoder<B, V> networkDecoder) {
        return new NetworkCodec<B, V>(){

            @Override
            public V decode(B in) {
                return networkDecoder.decode(in);
            }

            @Override
            public void encode(B out, V value) {
                networkMemberEncoder.encode(value, out);
            }
        };
    }
}

