/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.text.component;

import java.util.function.Function;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.text.minimessage.FormattedLine;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public sealed interface ComponentProvider
extends Function<Context, Component> {
    public static ComponentProvider constant(Component component) {
        return new Constant(component);
    }

    public static ComponentProvider miniMessageOrConstant(String line) {
        if (line.equals(AdventureHelper.customMiniMessage().stripTags(line, FormattedLine.CUSTOM_RESOLVERS))) {
            return ComponentProvider.constant(AdventureHelper.miniMessage().deserialize((Object)line));
        }
        return new MiniMessage(line);
    }

    public static non-sealed class Constant
    implements ComponentProvider {
        private final Component value;

        public Constant(Component value) {
            this.value = value;
        }

        @Override
        public Component apply(Context context) {
            return this.value;
        }
    }

    public static non-sealed class MiniMessage
    implements ComponentProvider {
        private final String value;

        public MiniMessage(String value) {
            this.value = value;
        }

        @Override
        public Component apply(Context context) {
            return AdventureHelper.miniMessage().deserialize(this.value, context.tagResolvers());
        }
    }
}

