/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.text.minimessage;

import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.Context;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.ParsingException;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.Tag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FormattedLine {
    public static final TagResolver[] CUSTOM_RESOLVERS = new TagResolver[]{FormattedLine.createDummyResolvers("expr"), FormattedLine.createDummyResolvers("image"), FormattedLine.createDummyResolvers("arg"), FormattedLine.createDummyResolvers("shift"), FormattedLine.createDummyResolvers("i18n"), FormattedLine.createDummyResolvers("global"), FormattedLine.createDummyResolvers("papi"), FormattedLine.createDummyResolvers("rel_papi")};

    public Component parse(net.momirealms.craftengine.core.plugin.context.Context var1);

    private static TagResolver createDummyResolvers(final String tag) {
        return new TagResolver(){

            public boolean has(@NotNull String name) {
                return tag.equals(name);
            }

            @Nullable
            public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
                return null;
            }
        };
    }

    public static FormattedLine create(String line) {
        if (line.equals(AdventureHelper.customMiniMessage().stripTags(line, CUSTOM_RESOLVERS))) {
            return new PreParsedLine(AdventureHelper.miniMessage().deserialize((Object)line));
        }
        return new DynamicLine(line);
    }

    public static class PreParsedLine
    implements FormattedLine {
        private final Component parsed;

        public PreParsedLine(Component parsed) {
            this.parsed = parsed;
        }

        @Override
        public Component parse(net.momirealms.craftengine.core.plugin.context.Context context) {
            return this.parsed;
        }
    }

    public static class DynamicLine
    implements FormattedLine {
        private final String content;

        public DynamicLine(String content) {
            this.content = content;
        }

        @Override
        public Component parse(net.momirealms.craftengine.core.plugin.context.Context context) {
            return AdventureHelper.miniMessage().deserialize(this.content, context.tagResolvers());
        }
    }
}

