/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.registry;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registry;
import net.momirealms.craftengine.core.registry.WritableRegistry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMappedRegistry<T>
implements WritableRegistry<T> {
    protected final ResourceKey<? extends Registry<T>> key;
    protected final Map<Key, Holder.Reference<T>> byResourceLocation;
    protected final Map<ResourceKey<T>, Holder.Reference<T>> byResourceKey;
    protected final List<Holder.Reference<T>> byId;

    protected AbstractMappedRegistry(ResourceKey<? extends Registry<T>> key, int expectedSize) {
        this.key = key;
        this.byResourceLocation = new HashMap<Key, Holder.Reference<T>>(expectedSize);
        this.byResourceKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>(expectedSize);
        this.byId = new ArrayList<Holder.Reference<T>>(expectedSize);
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    @Override
    @Nullable
    public T getValue(@Nullable ResourceKey<T> key) {
        return AbstractMappedRegistry.getValueFromNullable(this.byResourceKey.get(key));
    }

    @Override
    public Optional<Holder.Reference<T>> get(Key id) {
        return Optional.ofNullable(this.byResourceLocation.get(id));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
        return Optional.ofNullable(this.byResourceKey.get(key));
    }

    @Override
    @Nullable
    public T getValue(@Nullable Key id) {
        Holder.Reference<T> reference = this.byResourceLocation.get(id);
        return AbstractMappedRegistry.getValueFromNullable(reference);
    }

    @Override
    @Nullable
    public T getValue(int id) {
        if (id < 0 || id >= this.byId.size()) {
            return null;
        }
        return AbstractMappedRegistry.getValueFromNullable(this.byId.get(id));
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.Reference<T> entry) {
        return entry != null ? (T)entry.value() : null;
    }

    @Override
    public Set<Key> keySet() {
        return Collections.unmodifiableSet(this.byResourceLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byResourceKey.keySet());
    }

    @Override
    public boolean containsKey(Key id) {
        return this.byResourceLocation.containsKey(id);
    }

    @Override
    public boolean containsKey(ResourceKey<T> key) {
        return this.byResourceKey.containsKey(key);
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byResourceKey, Holder::value).entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.byResourceKey.isEmpty();
    }
}

