/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.registry;

import java.util.Objects;
import net.momirealms.craftengine.core.registry.AbstractMappedRegistry;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.registry.Registry;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.ResourceKey;
import org.jetbrains.annotations.Nullable;

public class DynamicBoundRegistry<T>
extends AbstractMappedRegistry<T> {
    public DynamicBoundRegistry(ResourceKey<? extends Registry<T>> key, int expectedSize) {
        super(key, expectedSize);
    }

    @Override
    public Holder.Reference<T> registerForHolder(ResourceKey<T> key) {
        Objects.requireNonNull(key);
        if (!key.registry().equals(this.key.location())) {
            throw new IllegalStateException(String.valueOf(key) + " is not allowed to be registered in " + String.valueOf(this.key));
        }
        if (this.byResourceLocation.containsKey(key.location())) {
            throw new IllegalStateException("Adding duplicate key '" + String.valueOf(key) + "' to registry");
        }
        Holder.Reference reference = this.byResourceKey.computeIfAbsent(key, k -> Holder.Reference.create(this, k));
        this.byResourceKey.put(key, reference);
        this.byResourceLocation.put(key.location(), reference);
        this.byId.add(reference);
        return reference;
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> key, T value) {
        Holder.Reference<T> holder = this.registerForHolder(key);
        holder.bindValue(value);
        return holder;
    }

    @Override
    public int getId(@Nullable T value) {
        throw new UnsupportedOperationException("getId is not supported for dynamic bound registry");
    }

    @Override
    public Key getKey(T value) {
        throw new UnsupportedOperationException("getKey is not supported for dynamic bound registry");
    }
}

