/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.sound;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.util.RandomUtils;

public record SoundData(Key id, SoundValue volume, SoundValue pitch) {
    public static SoundData create(Object obj, SoundValue volume, SoundValue pitch) {
        if (obj instanceof String) {
            String key = (String)obj;
            return new SoundData(Key.of(key), volume, pitch);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            Map<String, Object> data = MiscUtils.castToMap(map, false);
            Key id = Key.of((String)data.get("id"));
            SoundValue volumeValue = Optional.ofNullable(SoundValue.of(map.get("volume"))).orElse(volume);
            SoundValue pitchValue = Optional.ofNullable(SoundValue.of(map.get("pitch"))).orElse(volume);
            return new SoundData(id, volumeValue, pitchValue);
        }
        throw new IllegalArgumentException("Illegal object type for sound data: " + String.valueOf(obj.getClass()));
    }

    public static SoundData of(Key id, SoundValue volume, SoundValue pitch) {
        return new SoundData(id, volume, pitch);
    }

    public static interface SoundValue
    extends Supplier<Float> {
        public static final Map<Float, SoundValue> FIXED = new HashMap<Float, SoundValue>();
        public static final SoundValue FIXED_1 = new Fixed(1.0f);
        public static final SoundValue FIXED_0_8 = new Fixed(0.8f);
        public static final SoundValue FIXED_0_75 = new Fixed(0.75f);
        public static final SoundValue FIXED_0_15 = new Fixed(0.15f);
        public static final SoundValue FIXED_0_5 = new Fixed(0.5f);
        public static final SoundValue FIXED_0_3 = new Fixed(0.3f);

        public static SoundValue of(Object obj) {
            if (obj instanceof Number) {
                Number number = (Number)obj;
                return SoundValue.fixed(number.floatValue());
            }
            String volumeString = obj.toString();
            if (volumeString.contains("~")) {
                String[] split = volumeString.split("~");
                return SoundValue.ranged(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
            }
            return null;
        }

        public static SoundValue fixed(float value) {
            return FIXED.computeIfAbsent(Float.valueOf(value), v -> new Fixed(value));
        }

        public static SoundValue ranged(float min, float max) {
            return new Ranged(min, max);
        }

        public static class Ranged
        implements SoundValue {
            private final float min;
            private final float max;

            public Ranged(float min, float max) {
                this.min = min;
                this.max = max;
            }

            @Override
            public Float get() {
                return Float.valueOf(RandomUtils.generateRandomFloat(this.min, this.max));
            }
        }

        public static class Fixed
        implements SoundValue {
            private final float value;

            public Fixed(float value) {
                this.value = value;
            }

            @Override
            public Float get() {
                return Float.valueOf(this.value);
            }
        }
    }
}

