/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.momirealms.craftengine.core.block.entity.tick.TickingBlockEntity;

public final class BlockEntityTickersList
extends ObjectArrayList<TickingBlockEntity> {
    private final IntOpenHashSet toRemove = new IntOpenHashSet();
    private int startSearchFromIndex = -1;

    public BlockEntityTickersList() {
    }

    public BlockEntityTickersList(Collection<? extends TickingBlockEntity> c) {
        super(c);
    }

    public void markAsRemoved(int index) {
        if (this.startSearchFromIndex == -1) {
            this.startSearchFromIndex = index;
        }
        this.toRemove.add(index);
    }

    public void removeMarkedEntries() {
        if (this.startSearchFromIndex == -1) {
            return;
        }
        this.removeAllByIndex(this.startSearchFromIndex, this.toRemove);
        this.toRemove.clear();
        this.startSearchFromIndex = -1;
    }

    private void removeAllByIndex(int startSearchFromIndex, IntOpenHashSet c) {
        int finalBlockLength;
        int requiredMatches = c.size();
        if (requiredMatches == 0) {
            return;
        }
        Object[] a = this.a;
        int writeIndex = startSearchFromIndex;
        int lastCopyIndex = startSearchFromIndex;
        int matches = 0;
        for (int readIndex = startSearchFromIndex; readIndex < this.size; ++readIndex) {
            if (!c.contains(readIndex)) continue;
            ++matches;
            int blockLength = readIndex - lastCopyIndex;
            if (blockLength > 0) {
                System.arraycopy(a, lastCopyIndex, a, writeIndex, blockLength);
                writeIndex += blockLength;
            }
            lastCopyIndex = readIndex + 1;
            if (matches == requiredMatches) break;
        }
        if ((finalBlockLength = this.size - lastCopyIndex) > 0) {
            System.arraycopy(a, lastCopyIndex, a, writeIndex, finalBlockLength);
            writeIndex += finalBlockLength;
        }
        if (writeIndex < this.size) {
            Arrays.fill(a, writeIndex, this.size, null);
        }
        this.size = writeIndex;
    }
}

