/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ListMonitor<T>
implements List<T> {
    private final List<T> list;
    private final Consumer<T> addConsumer;
    private final Consumer<Object> removeConsumer;

    public ListMonitor(List<T> list, Consumer<T> addConsumer, Consumer<Object> removeConsumer) {
        this.list = list;
        this.addConsumer = addConsumer;
        this.removeConsumer = removeConsumer;
        for (T key : list) {
            this.addConsumer.accept(key);
        }
    }

    public List<T> list() {
        return this.list;
    }

    public Consumer<T> addConsumer() {
        return this.addConsumer;
    }

    public Consumer<Object> removeConsumer() {
        return this.removeConsumer;
    }

    @Override
    public synchronized boolean add(T t) {
        this.addConsumer.accept(t);
        return this.list.add(t);
    }

    @Override
    public synchronized boolean addAll(@NotNull Collection<? extends T> c) {
        for (T element : c) {
            this.addConsumer.accept(element);
        }
        return this.list.addAll(c);
    }

    @Override
    public synchronized boolean addAll(int index, @NotNull Collection<? extends T> c) {
        for (T element : c) {
            this.addConsumer.accept(element);
        }
        return this.list.addAll(index, c);
    }

    @Override
    public synchronized void add(int index, T element) {
        this.addConsumer.accept(element);
        this.list.add(index, element);
    }

    @Override
    public synchronized boolean remove(Object o) {
        this.removeConsumer.accept(o);
        return this.list.remove(o);
    }

    @Override
    public synchronized boolean removeAll(@NotNull Collection<?> collection) {
        for (Object o : collection) {
            this.removeConsumer.accept(o);
        }
        return this.list.removeAll(collection);
    }

    @Override
    public synchronized void clear() {
        for (T element : this.list) {
            this.removeConsumer.accept(element);
        }
        this.list.clear();
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    @NotNull
    public synchronized Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    @NotNull
    public synchronized Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @NotNull
    public synchronized <E> E[] toArray(@NotNull E[] a) {
        return this.list.toArray(a);
    }

    @Override
    @NotNull
    public synchronized List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized boolean containsAll(@NotNull Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public synchronized boolean retainAll(@NotNull Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public synchronized T get(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public synchronized T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public synchronized int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    @NotNull
    public synchronized ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @NotNull
    public synchronized ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }
}

