/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.plugin.locale.LocalizedException;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.util.QuaternionUtils;
import net.momirealms.craftengine.core.world.Vec3d;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class ResourceConfigUtils {
    private ResourceConfigUtils() {
    }

    public static <T, O> T getOrDefault(@Nullable O raw, Function<O, T> function, T defaultValue) {
        return raw != null ? function.apply(raw) : defaultValue;
    }

    public static <E extends Enum<E>> E getAsEnum(Object o, Class<E> clazz, E defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, o.toString().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static <T> T requireNonNullOrThrow(T obj, String node) {
        if (obj == null) {
            throw new LocalizedResourceConfigException(node, new String[0]);
        }
        return obj;
    }

    public static <T> T requireNonNullOrThrow(T obj, Supplier<LocalizedException> exceptionSupplier) {
        if (obj == null) {
            throw exceptionSupplier.get();
        }
        return obj;
    }

    public static String requireNonEmptyStringOrThrow(Object obj, String node) {
        Object o = ResourceConfigUtils.requireNonNullOrThrow(obj, node);
        String s = o.toString();
        if (s.isEmpty()) {
            throw new LocalizedResourceConfigException(node, new String[0]);
        }
        return s;
    }

    public static String requireNonEmptyStringOrThrow(Object obj, Supplier<LocalizedException> exceptionSupplier) {
        Object o = ResourceConfigUtils.requireNonNullOrThrow(obj, exceptionSupplier);
        String s = o.toString();
        if (s.isEmpty()) {
            throw exceptionSupplier.get();
        }
        return s;
    }

    public static <T> Either<T, List<T>> parseConfigAsEither(Object config, Function<Map<String, Object>, T> converter) {
        if (config instanceof Map) {
            return Either.left(converter.apply((Map)config));
        }
        if (config instanceof List) {
            List list = (List)config;
            return switch (list.size()) {
                case 0 -> Either.right(Collections.emptyList());
                case 1 -> Either.left(converter.apply((Map)list.get(0)));
                case 2 -> Either.right(List.of(converter.apply((Map)list.get(0)), converter.apply((Map)list.get(1))));
                default -> {
                    ArrayList<T> result = new ArrayList<T>(list.size());
                    for (Object o : list) {
                        result.add(converter.apply((Map)o));
                    }
                    yield Either.right(result);
                }
            };
        }
        return Either.right(Collections.emptyList());
    }

    public static <T> List<T> parseConfigAsList(Object config, Function<Map<String, Object>, T> converter) {
        if (config instanceof Map) {
            return List.of(converter.apply((Map)config));
        }
        if (config instanceof List) {
            List list = (List)config;
            return switch (list.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> List.of(converter.apply((Map)list.get(0)));
                case 2 -> List.of(converter.apply((Map)list.get(0)), converter.apply((Map)list.get(1)));
                default -> {
                    ArrayList result = new ArrayList(list.size());
                    for (Object o : list) {
                        result.add(converter.apply((Map)o));
                    }
                    yield result;
                }
            };
        }
        return Collections.emptyList();
    }

    public static Object get(Map<String, Object> arguments, String ... keys) {
        for (String key : keys) {
            Object value = arguments.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static int getAsInt(Object o, String option) {
        Object object = o;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Number.class, String.class, Boolean.class}, (Object)object, n)) {
            case -1: {
                return 0;
            }
            case 0: {
                Integer i = (Integer)object;
                return i;
            }
            case 1: {
                Number number = (Number)object;
                return number.intValue();
            }
            case 2: {
                String s = (String)object;
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new LocalizedResourceConfigException("warning.config.type.int", e, s, option);
                }
            }
            case 3: {
                Boolean b = (Boolean)object;
                return b != false ? 1 : 0;
            }
        }
        throw new LocalizedResourceConfigException("warning.config.type.int", o.toString(), option);
    }

    public static double getAsDouble(Object o, String option) {
        Object object = o;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Number.class, String.class}, (Object)object, n)) {
            case -1: {
                return 0.0;
            }
            case 0: {
                Double d = (Double)object;
                return d;
            }
            case 1: {
                Number n2 = (Number)object;
                return n2.doubleValue();
            }
            case 2: {
                String s = (String)object;
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    throw new LocalizedResourceConfigException("warning.config.type.double", e, s, option);
                }
            }
        }
        throw new LocalizedResourceConfigException("warning.config.type.double", o.toString(), option);
    }

    public static float getAsFloat(Object o, String option) {
        Object object = o;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, String.class, Number.class}, (Object)object, n)) {
            case -1: {
                return 0.0f;
            }
            case 0: {
                Float f = (Float)object;
                return f.floatValue();
            }
            case 1: {
                String s = (String)object;
                try {
                    return Float.parseFloat(s);
                }
                catch (NumberFormatException e) {
                    throw new LocalizedResourceConfigException("warning.config.type.float", e, s, option);
                }
            }
            case 2: {
                Number number = (Number)object;
                return number.floatValue();
            }
        }
        throw new LocalizedResourceConfigException("warning.config.type.float", o.toString(), option);
    }

    public static boolean getAsBoolean(Object o, String option) {
        Object object = o;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Number.class, String.class}, (Object)object, n)) {
            case -1: {
                return false;
            }
            case 0: {
                Boolean b = (Boolean)object;
                return b;
            }
            case 1: {
                Number n2 = (Number)object;
                if (n2.byteValue() == 0) {
                    return false;
                }
                if (n2.byteValue() == 1) {
                    return true;
                }
                throw new LocalizedResourceConfigException("warning.config.type.boolean", String.valueOf(n2), option);
            }
            case 2: {
                String s = (String)object;
                if (s.equalsIgnoreCase("true")) {
                    return true;
                }
                if (s.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new LocalizedResourceConfigException("warning.config.type.boolean", s, option);
            }
        }
        throw new LocalizedResourceConfigException("warning.config.type.boolean", o.toString(), option);
    }

    public static Map<String, Object> getAsMap(Object obj, String option) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map;
        }
        throw new LocalizedResourceConfigException("warning.config.type.map", String.valueOf(obj), option);
    }

    public static Map<String, Object> getAsMapOrNull(Object obj, String option) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map;
        }
        throw new LocalizedResourceConfigException("warning.config.type.map", String.valueOf(obj), option);
    }

    public static Vector3f getAsVector3f(Object o, String option) {
        List list;
        if (o == null) {
            return new Vector3f();
        }
        if (o instanceof List && (list = (List)o).size() == 3) {
            return new Vector3f(Float.parseFloat(list.get(0).toString()), Float.parseFloat(list.get(1).toString()), Float.parseFloat(list.get(2).toString()));
        }
        String stringFormat = o.toString();
        String[] split = stringFormat.split(",");
        if (split.length == 3) {
            return new Vector3f(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]));
        }
        if (split.length == 1) {
            return new Vector3f(Float.parseFloat(split[0]));
        }
        throw new LocalizedResourceConfigException("warning.config.type.vector3f", stringFormat, option);
    }

    public static Quaternionf getAsQuaternionf(Object o, String option) {
        List list;
        if (o == null) {
            return new Quaternionf();
        }
        if (o instanceof List && (list = (List)o).size() == 4) {
            return new Quaternionf(Float.parseFloat(list.get(0).toString()), Float.parseFloat(list.get(1).toString()), Float.parseFloat(list.get(2).toString()), Float.parseFloat(list.get(3).toString()));
        }
        String stringFormat = o.toString();
        String[] split = stringFormat.split(",");
        if (split.length == 4) {
            return new Quaternionf(Float.parseFloat(split[0]), Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]));
        }
        if (split.length == 3) {
            return QuaternionUtils.toQuaternionf((float)Math.toRadians(Float.parseFloat(split[2])), (float)Math.toRadians(Float.parseFloat(split[1])), (float)Math.toRadians(Float.parseFloat(split[0])));
        }
        if (split.length == 1) {
            return QuaternionUtils.toQuaternionf(0.0f, (float)(-Math.toRadians(Float.parseFloat(split[0]))), 0.0f);
        }
        throw new LocalizedResourceConfigException("warning.config.type.quaternionf", stringFormat, option);
    }

    public static Vec3d getAsVec3d(Object o, String option) {
        List list;
        if (o == null) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        if (o instanceof List && (list = (List)o).size() == 3) {
            return new Vec3d(Double.parseDouble(list.get(0).toString()), Double.parseDouble(list.get(1).toString()), Double.parseDouble(list.get(2).toString()));
        }
        String stringFormat = o.toString();
        String[] split = stringFormat.split(",");
        if (split.length == 3) {
            return new Vec3d(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
        }
        if (split.length == 1) {
            double d = Double.parseDouble(split[0]);
            return new Vec3d(d, d, d);
        }
        throw new LocalizedResourceConfigException("warning.config.type.vec3d", stringFormat, option);
    }
}

