/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.TypeUtils;
import net.momirealms.craftengine.libraries.boostedyaml.block.implementation.Section;

public class YamlUtils {
    private YamlUtils() {
    }

    public static Map<String, Object> sectionToMap(Section section) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        YamlUtils.sectionToMap(section, map);
        return map;
    }

    private static void sectionToMap(Section section, Map<String, Object> map) {
        for (Map.Entry entry : section.getStringRouteMappedValues(false).entrySet()) {
            char space;
            int second;
            char first;
            String str;
            Object value = entry.getValue();
            if (value instanceof Section) {
                Section inner = (Section)value;
                LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
                map.put((String)entry.getKey(), newMap);
                YamlUtils.sectionToMap(inner, newMap);
                continue;
            }
            if (value instanceof String && !(str = (String)value).isEmpty() && (first = str.charAt(0)) == '(' && (second = str.indexOf(41, 1)) != -1 && second + 1 + 1 < str.length() && (space = str.charAt(second + 1)) == ' ') {
                String castType = str.substring(1, second);
                String castValue = str.substring(second + 2);
                map.put((String)entry.getKey(), TypeUtils.castBasicTypes(castValue, castType));
                continue;
            }
            map.put((String)entry.getKey(), value);
        }
    }

    public static JsonObject sectionToJson(Section section) {
        JsonObject json = new JsonObject();
        YamlUtils.sectionToJson(section, json);
        return json;
    }

    private static void sectionToJson(Section section, JsonObject json) {
        for (Map.Entry entry : section.getStringRouteMappedValues(false).entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Section) {
                Section inner = (Section)value;
                JsonObject innerObject = new JsonObject();
                json.add(key, (JsonElement)innerObject);
                YamlUtils.sectionToJson(inner, innerObject);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                JsonArray array = new JsonArray();
                json.add(key, (JsonElement)array);
                for (Object o : list) {
                    YamlUtils.setJsonArray(array, o);
                }
                continue;
            }
            YamlUtils.setJsonProperty(json, key, value);
        }
    }

    public static JsonObject mapToJson(Map<String, Object> map) {
        return GsonHelper.get().toJsonTree(map).getAsJsonObject();
    }

    private static void setJsonArray(JsonArray array, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            JsonObject jsonObject = GsonHelper.get().toJsonTree((Object)map).getAsJsonObject();
            array.add((JsonElement)jsonObject);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            array.add(number);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            array.add(bool);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            array.add(character);
        } else {
            array.add(value.toString());
        }
    }

    private static void setJsonProperty(JsonObject json, String key, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            json.addProperty(key, number);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            json.addProperty(key, bool);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            json.addProperty(key, character);
        } else {
            json.addProperty(key, value.toString());
        }
    }
}

