/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world;

import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.Vec3i;

public class BlockPos
extends Vec3i {
    public static final BlockPos ZERO = new BlockPos(0, 0, 0);

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    @Override
    public BlockPos relative(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> new BlockPos(this.x(), this.y() + 1, this.z());
            case Direction.DOWN -> new BlockPos(this.x(), this.y() - 1, this.z());
            case Direction.NORTH -> new BlockPos(this.x(), this.y(), this.z() - 1);
            case Direction.SOUTH -> new BlockPos(this.x(), this.y(), this.z() + 1);
            case Direction.WEST -> new BlockPos(this.x() - 1, this.y(), this.z());
            case Direction.EAST -> new BlockPos(this.x() + 1, this.y(), this.z());
        };
    }

    public static BlockPos fromVec3d(Vec3d vec) {
        return new BlockPos(MCUtils.fastFloor(vec.x), MCUtils.fastFloor(vec.y), MCUtils.fastFloor(vec.z));
    }

    public static BlockPos of(long packedPos) {
        return new BlockPos((int)(packedPos >> 38), (int)(packedPos << 52 >> 52), (int)(packedPos << 26 >> 38));
    }

    @Override
    public BlockPos relative(Direction direction, int i) {
        return i == 0 ? this : new BlockPos(this.x() + direction.stepX() * i, this.y() + direction.stepY() * i, this.z() + direction.stepZ() * i);
    }

    public BlockPos above() {
        return new BlockPos(this.x(), this.y() + 1, this.z());
    }

    public int toSectionBlockIndex() {
        return (this.y & 0xF) << 8 | (this.z & 0xF) << 4 | this.x & 0xF;
    }

    public long asLong() {
        return BlockPos.asLong(this.x(), this.y(), this.z());
    }

    public static long asLong(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 38 | (long)y & 0xFFFL | ((long)z & 0x3FFFFFFL) << 12;
    }

    @Override
    public BlockPos offset(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.x() + x, this.y() + y, this.z() + z);
    }
}

