/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world;

import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.CEWorld;
import net.momirealms.craftengine.core.world.ChunkPos;
import net.momirealms.craftengine.core.world.ExistingBlock;
import net.momirealms.craftengine.core.world.Position;
import net.momirealms.craftengine.core.world.WorldHeight;
import net.momirealms.craftengine.core.world.particle.ParticleData;
import net.momirealms.craftengine.core.world.particle.ParticleType;
import org.jetbrains.annotations.NotNull;

public interface World {
    public CEWorld storageWorld();

    public Object platformWorld();

    public Object serverWorld();

    public WorldHeight worldHeight();

    public ExistingBlock getBlockAt(int var1, int var2, int var3);

    default public ExistingBlock getBlockAt(BlockPos pos) {
        return this.getBlockAt(pos.x(), pos.y(), pos.z());
    }

    public void setBlockAt(int var1, int var2, int var3, BlockStateWrapper var4, int var5);

    default public void setBlockAt(int x, int y, int z, ImmutableBlockState blockState, int flags) {
        this.setBlockAt(x, y, z, blockState.customBlockState(), flags);
    }

    public String name();

    public Path directory();

    public UUID uuid();

    public void dropItemNaturally(Position var1, Item<?> var2);

    public void dropExp(Position var1, int var2);

    public void playSound(Position var1, Key var2, float var3, float var4, SoundSource var5);

    public void playBlockSound(Position var1, Key var2, float var3, float var4);

    default public void playBlockSound(Position location, SoundData data) {
        this.playBlockSound(location, data.id(), ((Float)data.volume().get()).floatValue(), ((Float)data.pitch().get()).floatValue());
    }

    public void levelEvent(int var1, BlockPos var2, int var3);

    public void spawnParticle(Position var1, ParticleType var2, int var3, double var4, double var6, double var8, double var10, @Nullable ParticleData var12, @NotNull Context var13);

    public long time();

    public List<Player> getTrackedBy(ChunkPos var1);
}

