/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import net.momirealms.craftengine.core.block.entity.BlockEntityType;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.chunk.CEChunk;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;

public final class DefaultBlockEntitySerializer {
    public static ListTag serialize(Collection<BlockEntity> entities) {
        ListTag result = new ListTag();
        for (BlockEntity entity : entities) {
            if (!entity.isValid()) continue;
            result.add(entity.saveAsTag());
        }
        return result;
    }

    public static List<BlockEntity> deserialize(CEChunk chunk, ListTag tag) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>(tag.size());
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag data = tag.getCompound(i);
            Key id = Key.of(data.getString("id"));
            BlockEntityType<?> type = BuiltInRegistries.BLOCK_ENTITY_TYPE.getValue(id);
            if (type == null) {
                Debugger.BLOCK_ENTITY.debug(() -> "Unknown block entity type: " + String.valueOf(id));
                continue;
            }
            BlockPos pos = BlockEntity.readPosAndVerify(data, chunk.chunkPos());
            ImmutableBlockState blockState = chunk.getBlockState(pos);
            Object blockEntity = type.factory().create(pos, blockState);
            ((BlockEntity)blockEntity).loadCustomData(data);
            blockEntities.add((BlockEntity)blockEntity);
        }
        return blockEntities;
    }
}

