/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import biz.princeps.landlord.api.ILandLord;
import java.util.Optional;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class LandlordComp
extends AbstractComp {
    private ILandLord landLord;

    public LandlordComp(JavaPlugin plugin) {
        super(plugin, "Landlord");
    }

    @Override
    public void init() {
        this.landLord = (ILandLord)Bukkit.getPluginManager().getPlugin("Landlord");
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.landlordMemberCheck(player, location);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.landlordMemberCheck(player, location);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.landlordMemberCheck(player, location);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.landlordMemberCheck(player, entity.getLocation());
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.landlordMemberCheck(player, entity.getLocation());
    }

    private boolean landlordMemberCheck(Player player, Location location) {
        return Optional.ofNullable(this.landLord.getWGManager().getRegion(location)).map(region -> region.isOwner(player.getUniqueId()) || region.isFriend(player.getUniqueId())).orElse(false);
    }
}

