/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import p1xel.nobuildplus.API.NBPAPI;
import p1xel.nobuildplus.Flags;
import p1xel.nobuildplus.NoBuildPlus;

public class NoBuildPlusComp
extends AbstractComp {
    private NBPAPI nbpAPI;

    public NoBuildPlusComp(JavaPlugin plugin) {
        super(plugin, "NoBuildPlus");
    }

    @Override
    public void init() {
        this.nbpAPI = NoBuildPlus.getInstance().getAPI();
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.nbpAPI.canExecute(player.getWorld().getName(), Flags.build);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.nbpAPI.canExecute(player.getWorld().getName(), Flags.destroy);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.nbpAPI.canExecute(player.getWorld().getName(), Flags.use);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        String world = player.getWorld().getName();
        return switch (entity.getType()) {
            case EntityType.VILLAGER -> this.nbpAPI.canExecute(world, Flags.villager);
            case EntityType.HORSE, EntityType.DONKEY, EntityType.MULE, EntityType.SKELETON_HORSE, EntityType.ZOMBIE_HORSE, EntityType.MINECART, EntityType.MINECART_CHEST, EntityType.MINECART_FURNACE, EntityType.MINECART_HOPPER, EntityType.MINECART_TNT -> this.nbpAPI.canExecute(world, Flags.ride);
            case EntityType.ITEM_FRAME, EntityType.GLOW_ITEM_FRAME -> this.nbpAPI.canExecute(world, Flags.frame);
            case EntityType.ARMOR_STAND -> this.nbpAPI.canExecute(world, Flags.armorstand);
            case EntityType.PAINTING -> this.nbpAPI.canExecute(world, Flags.painting);
            case EntityType.FISHING_HOOK -> this.nbpAPI.canExecute(world, Flags.hook);
            default -> true;
        };
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.nbpAPI.canExecute(player.getWorld().getName(), entity instanceof Player ? Flags.pvp : Flags.mob_damage);
    }
}

