/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import java.util.Map;
import me.ulrich.clans.Clans;
import me.ulrich.clans.interfaces.ClaimImplement;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractComp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class UltimateClansComp
extends AbstractComp {
    private Clans clans;

    public UltimateClansComp(JavaPlugin plugin) {
        super(plugin, "UltimateClans");
    }

    @Override
    public void init() {
        this.clans = (Clans)Bukkit.getPluginManager().getPlugin("UltimateClans");
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.checkClaimedMember(player, location);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.checkClaimedMember(player, location);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.checkClaimedMember(player, location);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.checkClaimedMember(player, entity.getLocation());
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.checkClaimedMember(player, entity.getLocation());
    }

    private boolean checkClaimedMember(Player player, Location location) {
        for (Map.Entry entry : this.clans.getClaimAPI().findClaimedLocationImplement(location)) {
            ClaimImplement implement = (ClaimImplement)entry.getValue();
            if (implement.canDestroyClaimLocation(player, location) || implement.isOwnerClaimLocation(player, location) || implement.isMemberClaimLocation(player, location)) continue;
            return false;
        }
        return true;
    }
}

