/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.concurrentutil.executor.thread;

import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;
import net.momirealms.craftengine.libraries.concurrentutil.executor.PrioritisedExecutor;
import net.momirealms.craftengine.libraries.concurrentutil.util.ConcurrentUtil;
import net.momirealms.craftengine.libraries.concurrentutil.util.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrioritisedQueueExecutorThread
extends Thread
implements PrioritisedExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritisedQueueExecutorThread.class);
    protected final PrioritisedExecutor queue;
    protected volatile boolean threadShutdown;
    protected volatile boolean threadParked;
    protected static final VarHandle THREAD_PARKED_HANDLE = ConcurrentUtil.getVarHandle(PrioritisedQueueExecutorThread.class, "threadParked", Boolean.TYPE);
    protected volatile boolean halted;
    protected final long spinWaitTime;
    protected static final long DEFAULT_SPINWAIT_TIME = 100000L;

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue) {
        this(queue, 100000L);
    }

    public PrioritisedQueueExecutorThread(PrioritisedExecutor queue, long spinWaitTime) {
        this.queue = queue;
        this.spinWaitTime = spinWaitTime;
    }

    @Override
    public final void run() {
        try {
            this.begin();
            this.doRun();
        }
        finally {
            this.die();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void doRun() {
        spinWaitTime = this.spinWaitTime;
        block0: while (true) {
            this.pollTasks();
            start = System.nanoTime();
            do {
                Thread.interrupted();
                Thread.yield();
                LockSupport.parkNanos("Spinwaiting on tasks", 10000L);
                if (this.pollTasks()) continue block0;
                if (!this.handleClose()) continue;
                return;
            } while (System.nanoTime() - start < spinWaitTime);
            if (this.handleClose()) {
                return;
            }
            this.setThreadParkedVolatile(true);
            if (this.pollTasks()) {
                this.setThreadParkedVolatile(false);
                continue;
            }
            if (this.handleClose()) {
                return;
            }
            while (true) {
                if (this.getThreadParkedVolatile()) ** break;
                continue block0;
                Thread.interrupted();
                LockSupport.park("Waiting on tasks");
            }
            break;
        }
    }

    protected void begin() {
    }

    protected void die() {
    }

    protected boolean pollTasks() {
        boolean ret = false;
        while (!this.halted) {
            try {
                if (!this.queue.executeTask()) break;
                ret = true;
            }
            catch (Throwable throwable) {
                LOGGER.error("Exception thrown from prioritized runnable task in thread '" + this.getName() + "'", throwable);
            }
        }
        return ret;
    }

    protected boolean handleClose() {
        if (this.threadShutdown) {
            this.pollTasks();
            return true;
        }
        return false;
    }

    public boolean notifyTasks() {
        if (this.getThreadParkedVolatile() && this.exchangeThreadParkedVolatile(false)) {
            LockSupport.unpark(this);
            return true;
        }
        return false;
    }

    @Override
    public long getTotalTasksExecuted() {
        return this.queue.getTotalTasksExecuted();
    }

    @Override
    public long getTotalTasksScheduled() {
        return this.queue.getTotalTasksScheduled();
    }

    @Override
    public long generateNextSubOrder() {
        return this.queue.generateNextSubOrder();
    }

    @Override
    public boolean shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean executeTask() throws IllegalStateException {
        throw new IllegalStateException();
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder) {
        PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority, subOrder);
        ret.queue();
        return ret;
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task);
        return new WrappedTask(queueTask);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task, priority);
        return new WrappedTask(queueTask);
    }

    @Override
    public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder) {
        PrioritisedExecutor.PrioritisedTask queueTask = this.queue.createTask(task, priority, subOrder);
        return new WrappedTask(queueTask);
    }

    public boolean close(boolean wait, boolean killQueue) {
        boolean ret = killQueue && this.queue.shutdown();
        this.threadShutdown = true;
        this.setThreadParkedVolatile(false);
        LockSupport.unpark(this);
        if (wait) {
            boolean interrupted = false;
            while (true) {
                if (this.isAlive()) {
                    if (!interrupted) break;
                    Thread.currentThread().interrupt();
                    break;
                }
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
        }
        return ret;
    }

    public void halt(boolean killQueue) {
        if (killQueue) {
            this.queue.shutdown();
        }
        this.threadShutdown = true;
        this.halted = true;
        this.setThreadParkedVolatile(false);
        LockSupport.unpark(this);
    }

    protected final boolean getThreadParkedVolatile() {
        return THREAD_PARKED_HANDLE.getVolatile(this);
    }

    protected final boolean exchangeThreadParkedVolatile(boolean value) {
        return THREAD_PARKED_HANDLE.getAndSet(this, value);
    }

    protected final void setThreadParkedVolatile(boolean value) {
        THREAD_PARKED_HANDLE.setVolatile(this, value);
    }

    private final class WrappedTask
    implements PrioritisedExecutor.PrioritisedTask {
        private final PrioritisedExecutor.PrioritisedTask queueTask;

        public WrappedTask(PrioritisedExecutor.PrioritisedTask queueTask) {
            this.queueTask = queueTask;
        }

        @Override
        public PrioritisedExecutor getExecutor() {
            return PrioritisedQueueExecutorThread.this;
        }

        @Override
        public boolean queue() {
            boolean ret = this.queueTask.queue();
            if (ret) {
                PrioritisedQueueExecutorThread.this.notifyTasks();
            }
            return ret;
        }

        @Override
        public boolean isQueued() {
            return this.queueTask.isQueued();
        }

        @Override
        public boolean cancel() {
            return this.queueTask.cancel();
        }

        @Override
        public boolean execute() {
            return this.queueTask.execute();
        }

        @Override
        public Priority getPriority() {
            return this.queueTask.getPriority();
        }

        @Override
        public boolean setPriority(Priority priority) {
            return this.queueTask.setPriority(priority);
        }

        @Override
        public boolean raisePriority(Priority priority) {
            return this.queueTask.raisePriority(priority);
        }

        @Override
        public boolean lowerPriority(Priority priority) {
            return this.queueTask.lowerPriority(priority);
        }

        @Override
        public long getSubOrder() {
            return this.queueTask.getSubOrder();
        }

        @Override
        public boolean setSubOrder(long subOrder) {
            return this.queueTask.setSubOrder(subOrder);
        }

        @Override
        public boolean raiseSubOrder(long subOrder) {
            return this.queueTask.raiseSubOrder(subOrder);
        }

        @Override
        public boolean lowerSubOrder(long subOrder) {
            return this.queueTask.lowerSubOrder(subOrder);
        }

        @Override
        public boolean setPriorityAndSubOrder(Priority priority, long subOrder) {
            return this.queueTask.setPriorityAndSubOrder(priority, subOrder);
        }
    }
}

